/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.pipeline.discovery.ClientDiscoverHostHandler;
import dorkbox.network.pipeline.discovery.ClientDiscoverHostInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Broadcast {
    public static final byte broadcastID = 42;
    public static final byte broadcastResponseID = 57;
    private static final Logger logger = LoggerFactory.getLogger((String)"Broadcast Host Discovery");

    public static String getVersion() {
        return "2.4";
    }

    public static String discoverHost(int udpPort, int discoverTimeoutMillis) {
        InetAddress discoverHost = Broadcast.discoverHostAddress(udpPort, discoverTimeoutMillis);
        if (discoverHost != null) {
            return discoverHost.getHostAddress();
        }
        return null;
    }

    public static InetAddress discoverHostAddress(int udpPort, int discoverTimeoutMillis) {
        List<InetAddress> servers = Broadcast.discoverHost0(udpPort, discoverTimeoutMillis, false);
        if (servers.isEmpty()) {
            return null;
        }
        return servers.get(0);
    }

    public static List<InetAddress> discoverHosts(int udpPort, int discoverTimeoutMillis) {
        return Broadcast.discoverHost0(udpPort, discoverTimeoutMillis, true);
    }

    private static List<InetAddress> discoverHost0(int udpPort, int discoverTimeoutMillis, boolean fetchAllServers) {
        Enumeration<NetworkInterface> networkInterfaces;
        ByteBuf buffer = Unpooled.buffer((int)1);
        buffer.writeByte(42);
        ArrayList<InetAddress> servers = new ArrayList<InetAddress>();
        Logger logger2 = logger;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger2.error("Host discovery failed.", (Throwable)e);
            return new ArrayList<InetAddress>(0);
        }
        block8: for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress address = interfaceAddress.getAddress();
                InetAddress broadcast = interfaceAddress.getBroadcast();
                if (address instanceof Inet6Address) {
                    if (!logger2.isInfoEnabled()) continue;
                    logger2.info("Not using IPv6 address: {}", (Object)address);
                    continue;
                }
                try {
                    ChannelFuture future;
                    if (logger2.isInfoEnabled()) {
                        logger2.info("Searching for host on {} : {}", (Object)address, (Object)udpPort);
                    }
                    NioEventLoopGroup group = new NioEventLoopGroup();
                    Bootstrap udpBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ClientDiscoverHostInitializer())).localAddress((SocketAddress)new InetSocketAddress(address, 0));
                    try {
                        future = udpBootstrap.bind();
                        future.await();
                    }
                    catch (InterruptedException e) {
                        logger2.error("Could not bind to random UDP address on the server.", e.getCause());
                        throw new IllegalArgumentException();
                    }
                    if (!future.isSuccess()) {
                        logger2.error("Could not bind to random UDP address on the server.", future.cause());
                        throw new IllegalArgumentException();
                    }
                    Channel channel1 = future.channel();
                    if (broadcast != null) {
                        channel1.writeAndFlush((Object)new DatagramPacket(buffer, new InetSocketAddress(broadcast, udpPort)));
                        if (!channel1.closeFuture().awaitUninterruptibly((long)discoverTimeoutMillis)) {
                            if (logger2.isInfoEnabled()) {
                                logger2.info("Host discovery timed out.");
                            }
                        } else {
                            InetSocketAddress attachment = (InetSocketAddress)channel1.attr(ClientDiscoverHostHandler.STATE).get();
                            servers.add(attachment.getAddress());
                        }
                        if (!fetchAllServers && !servers.isEmpty()) {
                            channel1.close().await();
                            group.shutdownGracefully().await();
                            break block8;
                        }
                    }
                    byte[] ip = address.getAddress();
                    for (int octect = 3; octect >= 0; --octect) {
                        ip[octect] = -1;
                        try {
                            InetAddress byAddress = InetAddress.getByAddress(ip);
                            channel1.writeAndFlush((Object)new DatagramPacket(buffer, new InetSocketAddress(byAddress, udpPort)));
                            if (!channel1.closeFuture().awaitUninterruptibly((long)discoverTimeoutMillis)) {
                                if (!logger2.isInfoEnabled()) continue;
                                logger2.info("Host discovery timed out.");
                                continue;
                            }
                            InetSocketAddress attachment = (InetSocketAddress)channel1.attr(ClientDiscoverHostHandler.STATE).get();
                            servers.add(attachment.getAddress());
                            if (fetchAllServers) continue;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    channel1.close().sync();
                    group.shutdownGracefully(0L, (long)discoverTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fetchAllServers || servers.isEmpty()) continue;
                break block8;
            }
        }
        if (logger2.isInfoEnabled() && !servers.isEmpty()) {
            if (fetchAllServers) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Discovered servers: (").append(servers.size()).append(")");
                for (InetAddress server : servers) {
                    stringBuilder.append("/n").append(server).append(":").append(udpPort);
                }
                logger2.info(stringBuilder.toString());
            } else {
                logger2.info("Discovered server: {}:{}", servers.get(0), (Object)udpPort);
            }
        }
        return servers;
    }

    private Broadcast() {
    }
}

