/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.Configuration;
import dorkbox.network.connection.BootstrapWrapper;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.EndPointClient;
import dorkbox.network.connection.idle.IdleBridge;
import dorkbox.network.connection.idle.IdleSender;
import dorkbox.network.connection.registration.local.RegistrationLocalHandlerClient;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientUDP;
import dorkbox.network.rmi.RemoteObjectCallback;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.exceptions.InitializationException;
import dorkbox.util.exceptions.SecurityException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class Client<C extends Connection>
extends EndPointClient<C>
implements Connection {
    private final String localChannelName;
    private final String hostName;

    public static String getVersion() {
        return "2.4";
    }

    public Client() throws InitializationException, SecurityException, IOException {
        this(Configuration.localOnly());
    }

    public Client(String host, int tcpPort, int udpPort, String localChannelName) throws InitializationException, SecurityException, IOException {
        this(new Configuration(host, tcpPort, udpPort, localChannelName));
    }

    public Client(Configuration config) throws InitializationException, SecurityException, IOException {
        super(config);
        boolean isLocalChannel;
        String threadName = Client.class.getSimpleName();
        boolean hostConfigured = (config.tcpPort > 0 || config.udpPort > 0) && config.host != null;
        boolean bl = isLocalChannel = config.localChannelName != null;
        if (isLocalChannel && hostConfigured) {
            String msg = threadName + " Local channel use and TCP/UDP use are MUTUALLY exclusive. Unable to determine what to do.";
            this.logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.localChannelName = config.localChannelName;
        this.hostName = config.host;
        boolean isAndroid = PlatformDependent.isAndroid();
        Object boss = isAndroid ? new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup)) : (OS.isLinux() ? new EpollEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup)) : new NioEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup)));
        this.manageForShutdown((EventLoopGroup)boss);
        if (config.localChannelName != null && config.tcpPort <= 0 && config.udpPort <= 0) {
            Bootstrap localBootstrap = new Bootstrap();
            this.bootstraps.add(new BootstrapWrapper("LOCAL", config.localChannelName, -1, localBootstrap));
            DefaultEventLoopGroup localBoss = new DefaultEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-LOCAL", this.threadGroup));
            ((Bootstrap)((Bootstrap)localBootstrap.group((EventLoopGroup)localBoss)).channel(LocalChannel.class)).remoteAddress((SocketAddress)new LocalAddress(config.localChannelName)).handler(new RegistrationLocalHandlerClient(threadName, this.registrationWrapper));
            this.manageForShutdown((EventLoopGroup)localBoss);
        } else {
            if (config.host == null) {
                throw new IllegalArgumentException("You must define what host you want to connect to.");
            }
            if (config.tcpPort <= 0 && config.udpPort <= 0) {
                throw new IllegalArgumentException("You must define what port you want to connect to.");
            }
            if (config.tcpPort > 0) {
                Bootstrap tcpBootstrap = new Bootstrap();
                this.bootstraps.add(new BootstrapWrapper("TCP", config.host, config.tcpPort, tcpBootstrap));
                if (isAndroid) {
                    tcpBootstrap.channel(OioSocketChannel.class);
                } else if (OS.isLinux()) {
                    tcpBootstrap.channel(EpollSocketChannel.class);
                } else {
                    tcpBootstrap.channel(NioSocketChannel.class);
                }
                ((Bootstrap)((Bootstrap)((Bootstrap)tcpBootstrap.group((EventLoopGroup)boss)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).remoteAddress(config.host, config.tcpPort).handler(new RegistrationRemoteHandlerClientTCP(threadName, this.registrationWrapper, this.serializationManager));
                ((Bootstrap)tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!isAndroid ? 1 : 0))).option(ChannelOption.SO_KEEPALIVE, (Object)true);
            }
            if (config.udpPort > 0) {
                Bootstrap udpBootstrap = new Bootstrap();
                this.bootstraps.add(new BootstrapWrapper("UDP", config.host, config.udpPort, udpBootstrap));
                if (isAndroid) {
                    udpBootstrap.channel(OioDatagramChannel.class);
                } else if (OS.isLinux()) {
                    udpBootstrap.channel(EpollDatagramChannel.class);
                } else {
                    udpBootstrap.channel(NioDatagramChannel.class);
                }
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group((EventLoopGroup)boss)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress((SocketAddress)new InetSocketAddress(0))).remoteAddress((SocketAddress)new InetSocketAddress(config.host, config.udpPort)).handler(new RegistrationRemoteHandlerClientUDP(threadName, this.registrationWrapper, this.serializationManager));
                ((Bootstrap)udpBootstrap.option(ChannelOption.SO_BROADCAST, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)udpMaxSize);
            }
        }
    }

    public void reconnect() throws IOException {
        this.reconnect(this.connectionTimeout);
    }

    public void reconnect(int connectionTimeout) throws IOException {
        this.closeConnections();
        this.connect(connectionTimeout);
    }

    public void connect() throws IOException {
        this.connect(30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int connectionTimeout) throws IOException {
        this.connectionTimeout = connectionTimeout;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        if (this.localChannelName != null) {
            this.logger.info("Connecting to local server: {}", (Object)this.localChannelName);
        } else {
            this.logger.info("Connecting to server: {}", (Object)this.hostName);
        }
        this.registerNextProtocol();
        object = this.registrationLock;
        synchronized (object) {
            if (!this.registrationComplete) {
                try {
                    this.registrationLock.wait(connectionTimeout);
                }
                catch (InterruptedException e) {
                    throw new IOException("Unable to complete registration within '" + connectionTimeout + "' milliseconds", e);
                }
            }
        }
        this.waitForRmi(connectionTimeout);
    }

    @Override
    public boolean hasRemoteKeyChanged() {
        return this.connection.hasRemoteKeyChanged();
    }

    @Override
    public String getRemoteHost() {
        return this.connection.getRemoteHost();
    }

    @Override
    public boolean isLoopback() {
        return this.connection.isLoopback();
    }

    @Override
    public EndPointBase getEndPoint() {
        return this;
    }

    @Override
    public int id() {
        return this.connection.id();
    }

    @Override
    public String idAsHex() {
        return this.connection.idAsHex();
    }

    @Override
    public boolean hasUDP() {
        return this.connection.hasUDP();
    }

    @Override
    public IdleBridge sendOnIdle(IdleSender<?, ?> sender) {
        return this.connection.sendOnIdle(sender);
    }

    @Override
    public IdleBridge sendOnIdle(Object message) {
        return this.connection.sendOnIdle(message);
    }

    @Override
    public void closeAsap() {
        this.connection.closeAsap();
    }

    @Override
    public <Iface> void getRemoteObject(Class<Iface> interfaceClass, RemoteObjectCallback<Iface> callback) throws IOException {
        this.connectionManager.getConnection0().getRemoteObject(interfaceClass, callback);
    }

    @Override
    public <Iface> void getRemoteObject(int objectId, RemoteObjectCallback<Iface> callback) throws IOException {
        this.connectionManager.getConnection0().getRemoteObject(objectId, callback);
    }

    public C getConnection() {
        return (C)this.connection;
    }

    @Override
    public void close() {
        this.closeConnections();
    }
}

