/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.connection.EndPoint;
import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.DnsResponse;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.network.dns.resolver.DnsQueryLifecycleObserverFactory;
import dorkbox.network.dns.resolver.NoopDnsQueryLifecycleObserverFactory;
import dorkbox.network.dns.resolver.addressProvider.DefaultDnsServerAddressStreamProvider;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStreamProvider;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStreamProviders;
import dorkbox.network.dns.resolver.addressProvider.SequentialDnsServerAddressStreamProvider;
import dorkbox.network.dns.resolver.cache.DefaultDnsCache;
import dorkbox.network.dns.resolver.cache.DnsCache;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.Property;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsClient
extends EndPoint {
    @Property
    public static List<InetSocketAddress> DNS_SERVER_LIST = Arrays.asList(new InetSocketAddress("8.8.8.8", 53), new InetSocketAddress("8.8.4.4", 53), new InetSocketAddress("208.67.222.222", 53), new InetSocketAddress("208.67.220.220", 53), new InetSocketAddress("37.235.1.174", 53), new InetSocketAddress("37.235.1.177", 53));
    public static final List<InetSocketAddress> DEFAULT_DNS_SERVER_LIST = DefaultDnsServerAddressStreamProvider.defaultAddressList();
    public static final InetAddress[] INET_ADDRESSES = new InetAddress[0];
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<? extends DatagramChannel> channelType;
    private DnsNameResolver resolver;
    private ThreadGroup threadGroup;
    private static final String THREAD_NAME = "DnsClient";
    private EventLoopGroup eventLoopGroup;
    private ChannelFactory<? extends DatagramChannel> channelFactory;
    private DnsCache resolveCache;
    private DnsCache authoritativeDnsServerCache;
    private Integer minTtl;
    private Integer maxTtl;
    private Integer negativeTtl;
    private long queryTimeoutMillis = 5000L;
    private ResolvedAddressTypes resolvedAddressTypes = DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = 16;
    private boolean traceEnabled;
    private int maxPayloadSize = 4096;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider = DnsServerAddressStreamProviders.platformDefault();
    private DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory = NoopDnsQueryLifecycleObserverFactory.INSTANCE;
    private String[] searchDomains;
    private int ndots = -1;
    private boolean decodeIdn = true;

    public static String getVersion() {
        return "2.4";
    }

    public static InetAddress getPublicIp() {
        InetSocketAddress dnsServer = new InetSocketAddress("208.67.222.222", 53);
        DnsClient dnsClient = new DnsClient(dnsServer);
        List<InetAddress> resolved = null;
        try {
            resolved = dnsClient.resolve("myip.opendns.com");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dnsClient.stop();
        if (resolved != null && resolved.size() > 0) {
            return resolved.get(0);
        }
        return null;
    }

    public DnsClient() {
        this(DNS_SERVER_LIST);
    }

    public DnsClient(String nameServerAddresses) {
        this(nameServerAddresses, 53);
    }

    public DnsClient(String nameServerAddresses, int port) {
        this(Collections.singletonList(new InetSocketAddress(nameServerAddresses, port)));
    }

    public DnsClient(InetSocketAddress nameServerAddresses) {
        this(Collections.singletonList(nameServerAddresses));
    }

    public DnsClient(Collection<InetSocketAddress> nameServerAddresses) {
        super(DnsClient.class);
        if (PlatformDependent.isAndroid()) {
            this.eventLoopGroup = new OioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("DnsClient-DNS", this.threadGroup));
            this.channelType = OioDatagramChannel.class;
        } else if (OS.isLinux()) {
            this.eventLoopGroup = new EpollEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("DnsClient-DNS", this.threadGroup));
            this.channelType = EpollDatagramChannel.class;
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("DnsClient-DNS", this.threadGroup));
            this.channelType = NioDatagramChannel.class;
        }
        this.manageForShutdown(this.eventLoopGroup);
        if (nameServerAddresses != null) {
            this.dnsServerAddressStreamProvider = new SequentialDnsServerAddressStreamProvider(nameServerAddresses);
        }
    }

    public DnsClient resolveCache(DnsCache resolveCache) {
        this.resolveCache = resolveCache;
        return this;
    }

    public DnsClient dnsQueryLifecycleObserverFactory(DnsQueryLifecycleObserverFactory lifecycleObserverFactory) {
        this.dnsQueryLifecycleObserverFactory = (DnsQueryLifecycleObserverFactory)ObjectUtil.checkNotNull((Object)lifecycleObserverFactory, (String)"lifecycleObserverFactory");
        return this;
    }

    public DnsClient authoritativeDnsServerCache(DnsCache authoritativeDnsServerCache) {
        this.authoritativeDnsServerCache = authoritativeDnsServerCache;
        return this;
    }

    public DnsClient ttl(int minTtl, int maxTtl) {
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this;
    }

    public DnsClient negativeTtl(int negativeTtl) {
        this.negativeTtl = negativeTtl;
        return this;
    }

    public DnsClient queryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public DnsClient resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
        this.resolvedAddressTypes = resolvedAddressTypes;
        return this;
    }

    public DnsClient recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public DnsClient maxQueriesPerResolve(int maxQueriesPerResolve) {
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public DnsClient traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public DnsClient maxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public DnsClient hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this;
    }

    public DnsClient nameServerProvider(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = (DnsServerAddressStreamProvider)ObjectUtil.checkNotNull((Object)dnsServerAddressStreamProvider, (String)"dnsServerAddressStreamProvider");
        return this;
    }

    public DnsClient searchDomains(Iterable<String> searchDomains) {
        ObjectUtil.checkNotNull(searchDomains, (String)"searchDomains");
        ArrayList<String> list = new ArrayList<String>(4);
        for (String f : searchDomains) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        this.searchDomains = list.toArray(new String[list.size()]);
        return this;
    }

    public DnsClient ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    private DnsCache newCache() {
        return new DefaultDnsCache(ObjectUtil.intValue((Integer)this.minTtl, (int)0), ObjectUtil.intValue((Integer)this.maxTtl, (int)Integer.MAX_VALUE), ObjectUtil.intValue((Integer)this.negativeTtl, (int)0));
    }

    public DnsClient decodeToUnicode(boolean decodeIdn) {
        this.decodeIdn = decodeIdn;
        return this;
    }

    public static ResolvedAddressTypes computeResolvedAddressTypes(InternetProtocolFamily ... internetProtocolFamilies) {
        if (internetProtocolFamilies == null || internetProtocolFamilies.length == 0) {
            return DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
        }
        if (internetProtocolFamilies.length > 2) {
            throw new IllegalArgumentException("No more than 2 InternetProtocolFamilies");
        }
        switch (internetProtocolFamilies[0]) {
            case IPv4: {
                return internetProtocolFamilies.length >= 2 && internetProtocolFamilies[1] == InternetProtocolFamily.IPv6 ? ResolvedAddressTypes.IPV4_PREFERRED : ResolvedAddressTypes.IPV4_ONLY;
            }
            case IPv6: {
                return internetProtocolFamilies.length >= 2 && internetProtocolFamilies[1] == InternetProtocolFamily.IPv4 ? ResolvedAddressTypes.IPV6_PREFERRED : ResolvedAddressTypes.IPV6_ONLY;
            }
        }
        throw new IllegalArgumentException("Couldn't resolve ResolvedAddressTypes from InternetProtocolFamily array");
    }

    public DnsClient start() {
        ReflectiveChannelFactory channelFactory = new ReflectiveChannelFactory(this.channelType);
        if (this.resolvedAddressTypes == null) {
            this.resolvedAddressTypes = ResolvedAddressTypes.IPV4_ONLY;
        }
        if (this.resolveCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("resolveCache and TTLs are mutually exclusive");
        }
        if (this.authoritativeDnsServerCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("authoritativeDnsServerCache and TTLs are mutually exclusive");
        }
        DnsCache resolveCache = this.resolveCache != null ? this.resolveCache : this.newCache();
        DnsCache authoritativeDnsServerCache = this.authoritativeDnsServerCache != null ? this.authoritativeDnsServerCache : this.newCache();
        this.resolver = new DnsNameResolver(this.eventLoopGroup.next(), (ChannelFactory<? extends DatagramChannel>)channelFactory, resolveCache, authoritativeDnsServerCache, this.dnsQueryLifecycleObserverFactory, this.queryTimeoutMillis, this.resolvedAddressTypes, this.recursionDesired, this.maxQueriesPerResolve, this.traceEnabled, this.maxPayloadSize, this.hostsFileEntriesResolver, this.dnsServerAddressStreamProvider, this.searchDomains, this.ndots, this.decodeIdn);
        return this;
    }

    public void reset() {
        if (this.resolver == null) {
            this.start();
        }
        this.clearResolver();
    }

    private void clearResolver() {
        this.resolver.resolveCache().clear();
    }

    @Override
    protected void stopExtraActions() {
        if (this.resolver != null) {
            this.clearResolver();
            this.resolver.close();
        }
    }

    public List<InetAddress> resolve(String hostname) throws UnknownHostException {
        return this.resolve(hostname, 5);
    }

    public List<InetAddress> resolve(String hostname, int queryTimeoutSeconds) throws UnknownHostException {
        Future resolve;
        boolean finished;
        if (hostname == null) {
            throw new UnknownHostException("Cannot submit query for an unknown host");
        }
        if (this.resolver == null) {
            this.start();
        }
        if ((finished = (resolve = this.resolver.resolveAll(hostname)).awaitUninterruptibly((long)queryTimeoutSeconds, TimeUnit.SECONDS)) && resolve.isSuccess() && resolve.isDone()) {
            try {
                List now = (List)resolve.getNow();
                return now;
            }
            catch (Exception e) {
                String msg = "Could not ask question to DNS server";
                this.logger.error(msg, (Throwable)e);
                throw new UnknownHostException(msg);
            }
        }
        String msg = "Could not ask question to DNS server for A/AAAA record: {}";
        this.logger.error(msg, (Object)hostname);
        UnknownHostException cause = (UnknownHostException)resolve.cause();
        if (cause != null) {
            throw cause;
        }
        throw new UnknownHostException(msg);
    }

    public DnsRecord[] query(String hostname, int type) throws UnknownHostException {
        return this.query(hostname, type, 5);
    }

    public DnsRecord[] query(String hostname, int type, int queryTimeoutSeconds) throws UnknownHostException {
        DnsQuestion dnsMessage;
        Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query;
        boolean finished;
        if (hostname == null) {
            throw new UnknownHostException("Cannot submit query for an unknown host");
        }
        if (this.resolver == null) {
            this.start();
        }
        if ((finished = (query = this.resolver.query(dnsMessage = DnsQuestion.newQuery(hostname, type, this.recursionDesired))).awaitUninterruptibly((long)queryTimeoutSeconds, TimeUnit.SECONDS)) && query.isSuccess() && query.isDone()) {
            AddressedEnvelope envelope = (AddressedEnvelope)query.getNow();
            DnsResponse response = (DnsResponse)envelope.content();
            try {
                int code = response.getHeader().getRcode();
                if (code == 0) {
                    DnsRecord[] dnsRecordArray = response.getSectionArray(1);
                    return dnsRecordArray;
                }
                String msg = "Could not ask question to DNS server: Error code " + code + " for type: " + type + " - " + DnsRecordType.string(type);
                this.logger.error(msg);
                throw new UnknownHostException(msg);
            }
            finally {
                response.release();
            }
        }
        String msg = "Could not ask question to DNS server for type: " + DnsRecordType.string(type);
        this.logger.error(msg);
        UnknownHostException cause = (UnknownHostException)query.cause();
        if (cause != null) {
            throw cause;
        }
        throw new UnknownHostException(msg);
    }
}

