/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.dns.serverHandlers.DnsServerHandler;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.Property;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class DnsServer
extends EndPoint {
    @Property
    public static int backlogConnectionCount = 50;
    private final ServerBootstrap tcpBootstrap;
    private final Bootstrap udpBootstrap;
    private final int tcpPort;
    private final int udpPort;
    private final String hostName;

    public DnsServer(String host, int port) {
        super(DnsServer.class);
        OioEventLoopGroup worker;
        OioEventLoopGroup boss;
        this.tcpPort = port;
        this.udpPort = port;
        this.hostName = host == null ? "0.0.0.0" : host;
        String threadName = DnsServer.class.getSimpleName();
        if (OS.isAndroid()) {
            boss = new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else if (OS.isLinux()) {
            boss = new EpollEventLoopGroup(EndPointBase.DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new EpollEventLoopGroup(EndPointBase.DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else {
            boss = new NioEventLoopGroup(EndPointBase.DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new NioEventLoopGroup(EndPointBase.DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        }
        this.manageForShutdown((EventLoopGroup)boss);
        this.manageForShutdown((EventLoopGroup)worker);
        this.tcpBootstrap = new ServerBootstrap();
        this.udpBootstrap = new Bootstrap();
        if (OS.isAndroid()) {
            this.tcpBootstrap.channel(OioServerSocketChannel.class);
        } else if (OS.isLinux()) {
            this.tcpBootstrap.channel(EpollServerSocketChannel.class);
        } else {
            this.tcpBootstrap.channel(NioServerSocketChannel.class);
        }
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.tcpBootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker).option(ChannelOption.SO_BACKLOG, (Object)backlogConnectionCount)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new DnsServerHandler());
        if (this.hostName != null) {
            this.tcpBootstrap.localAddress(this.hostName, this.tcpPort);
        } else {
            this.tcpBootstrap.localAddress(this.tcpPort);
        }
        ((ServerBootstrap)this.tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0))).childOption(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0));
        if (OS.isAndroid()) {
            this.udpBootstrap.channel(OioDatagramChannel.class);
        } else if (OS.isLinux()) {
            ((Bootstrap)this.udpBootstrap.channel(EpollDatagramChannel.class)).option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        } else {
            this.udpBootstrap.channel(NioDatagramChannel.class);
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.udpBootstrap.group((EventLoopGroup)worker)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress(this.udpPort)).handler((ChannelHandler)new DnsServerHandler());
    }

    public void bind() {
        this.bind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(boolean blockUntilTerminate) {
        ChannelFuture future;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        Logger logger2 = this.logger;
        try {
            future = this.udpBootstrap.bind();
            future.await();
        }
        catch (Exception e) {
            String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", e);
            throw new IllegalArgumentException(errorMessage);
        }
        if (!future.isSuccess()) {
            String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", future.cause());
            throw new IllegalArgumentException(errorMessage);
        }
        this.manageForShutdown(future);
        if (blockUntilTerminate) {
            this.waitForShutdown();
        }
    }
}

