/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.Configuration;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.registration.local.RegistrationLocalHandlerServer;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerUDP;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.Property;
import dorkbox.util.exceptions.InitializationException;
import dorkbox.util.exceptions.SecurityException;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class Server<C extends Connection>
extends EndPointServer<C> {
    @Property
    public static int backlogConnectionCount = 50;
    private final ServerBootstrap localBootstrap;
    private final ServerBootstrap tcpBootstrap;
    private final Bootstrap udpBootstrap;
    private final int tcpPort;
    private final int udpPort;
    private final String localChannelName;
    private final String hostName;
    private volatile boolean isRunning = false;

    public static String getVersion() {
        return "2.4";
    }

    public Server() throws InitializationException, SecurityException, IOException {
        this(Configuration.localOnly());
    }

    public Server(Configuration config) throws InitializationException, SecurityException, IOException {
        super(config);
        OioEventLoopGroup worker;
        OioEventLoopGroup boss;
        this.tcpPort = config.tcpPort;
        this.udpPort = config.udpPort;
        this.localChannelName = config.localChannelName;
        if (config.host == null) {
            config.host = this.hostName = "0.0.0.0";
        } else {
            this.hostName = config.host;
        }
        this.localBootstrap = this.localChannelName != null ? new ServerBootstrap() : null;
        this.tcpBootstrap = this.tcpPort > 0 ? new ServerBootstrap() : null;
        this.udpBootstrap = this.udpPort > 0 ? new Bootstrap() : null;
        String threadName = Server.class.getSimpleName();
        if (OS.isAndroid()) {
            boss = new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else if (OS.isLinux()) {
            boss = new EpollEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new EpollEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else {
            boss = new NioEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            worker = new NioEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        }
        this.manageForShutdown((EventLoopGroup)boss);
        this.manageForShutdown((EventLoopGroup)worker);
        if (this.localBootstrap != null) {
            DefaultEventLoopGroup localBoss = new DefaultEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-boss-LOCAL", this.threadGroup));
            DefaultEventLoopGroup localWorker = new DefaultEventLoopGroup(DEFAULT_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName + "-worker-LOCAL", this.threadGroup));
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.localBootstrap.group((EventLoopGroup)localBoss, (EventLoopGroup)localWorker).channel(LocalServerChannel.class)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress((SocketAddress)new LocalAddress(this.localChannelName))).childHandler(new RegistrationLocalHandlerServer(threadName, this.registrationWrapper));
            this.manageForShutdown((EventLoopGroup)localBoss);
            this.manageForShutdown((EventLoopGroup)localWorker);
        }
        if (this.tcpBootstrap != null) {
            if (OS.isAndroid()) {
                this.tcpBootstrap.channel(OioServerSocketChannel.class);
            } else if (OS.isLinux()) {
                this.tcpBootstrap.channel(EpollServerSocketChannel.class);
            } else {
                this.tcpBootstrap.channel(NioServerSocketChannel.class);
            }
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.tcpBootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker).option(ChannelOption.SO_BACKLOG, (Object)backlogConnectionCount)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler(new RegistrationRemoteHandlerServerTCP(threadName, this.registrationWrapper, this.serializationManager));
            if (this.hostName.equals("0.0.0.0")) {
                this.tcpBootstrap.localAddress(this.hostName, this.tcpPort);
            } else {
                this.tcpBootstrap.localAddress(this.tcpPort);
            }
            ((ServerBootstrap)this.tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0))).childOption(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0));
        }
        if (this.udpBootstrap != null) {
            if (OS.isAndroid()) {
                this.udpBootstrap.channel(OioDatagramChannel.class);
            } else if (OS.isLinux()) {
                ((Bootstrap)this.udpBootstrap.channel(EpollDatagramChannel.class)).option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            } else {
                this.udpBootstrap.channel(NioDatagramChannel.class);
            }
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.udpBootstrap.group((EventLoopGroup)worker)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress(this.udpPort)).handler(new RegistrationRemoteHandlerServerUDP(threadName, this.registrationWrapper, this.serializationManager));
            ((Bootstrap)this.udpBootstrap.option(ChannelOption.SO_BROADCAST, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)udpMaxSize);
        }
    }

    public void bind() {
        this.bind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(boolean blockUntilTerminate) {
        ChannelFuture future;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        Logger logger2 = this.logger;
        if (this.localBootstrap != null) {
            try {
                future = this.localBootstrap.bind();
                future.await();
            }
            catch (InterruptedException e) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to LOCAL address on the server.", e);
                throw new IllegalArgumentException(errorMessage);
            }
            if (!future.isSuccess()) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to LOCAL address on the server.", future.cause());
                throw new IllegalArgumentException(errorMessage);
            }
            logger2.info("Listening on LOCAL address: '{}'", (Object)this.localChannelName);
            this.manageForShutdown(future);
        }
        if (this.tcpBootstrap != null) {
            try {
                future = this.tcpBootstrap.bind();
                future.await();
            }
            catch (Exception e) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " TCP port " + this.tcpPort + " on the server.", e);
                throw new IllegalArgumentException(errorMessage);
            }
            if (!future.isSuccess()) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " TCP port " + this.tcpPort + " on the server.", future.cause());
                throw new IllegalArgumentException(errorMessage);
            }
            logger2.info("Listening on address {} at TCP port: {}", (Object)this.hostName, (Object)this.tcpPort);
            this.manageForShutdown(future);
        }
        if (this.udpBootstrap != null) {
            try {
                future = this.udpBootstrap.bind();
                future.await();
            }
            catch (Exception e) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", e);
                throw new IllegalArgumentException(errorMessage);
            }
            if (!future.isSuccess()) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", future.cause());
                throw new IllegalArgumentException(errorMessage);
            }
            logger2.info("Listening on address {} at UDP port: {}", (Object)this.hostName, (Object)this.udpPort);
            this.manageForShutdown(future);
        }
        this.isRunning = true;
        if (blockUntilTerminate) {
            this.waitForShutdown();
        }
    }

    @Override
    protected void stopExtraActions() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static boolean isRunning(Configuration config) {
        String host = config.host;
        if (host == null) {
            host = "0.0.0.0";
        }
        if (config.tcpPort == 0) {
            return false;
        }
        Socket sock = null;
        try {
            sock = new Socket(host, config.tcpPort);
            return sock.isConnected();
        }
        catch (Exception ignored) {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

