/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.Registration;
import dorkbox.network.connection.ClassObject;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionManager;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.ConnectionPointWriter;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.ICryptoConnection;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.Listener;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.Ping;
import dorkbox.network.connection.bridge.ConnectionBridge;
import dorkbox.network.connection.idle.IdleBridge;
import dorkbox.network.connection.idle.IdleSender;
import dorkbox.network.connection.idle.IdleSenderFactory;
import dorkbox.network.connection.ping.PingFuture;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.network.connection.ping.PingTuple;
import dorkbox.network.connection.wrapper.ChannelNetworkWrapper;
import dorkbox.network.connection.wrapper.ChannelNull;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.rmi.RemoteObject;
import dorkbox.network.rmi.RemoteObjectCallback;
import dorkbox.network.rmi.Rmi;
import dorkbox.network.rmi.RmiBridge;
import dorkbox.network.rmi.RmiRegistration;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.collections.IntMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ConnectionImpl
extends ChannelInboundHandlerAdapter
implements ICryptoConnection,
Connection,
Listeners,
ConnectionBridge {
    private final Logger logger;
    private final AtomicBoolean needsLock = new AtomicBoolean(false);
    private final AtomicBoolean writeSignalNeeded = new AtomicBoolean(false);
    private final Object writeLock = new Object();
    private final AtomicBoolean closeInProgress = new AtomicBoolean(false);
    private final AtomicBoolean alreadyClosed = new AtomicBoolean(false);
    private final Object closeInProgressLock = new Object();
    private final Object messageInProgressLock = new Object();
    private final AtomicBoolean messageInProgress = new AtomicBoolean(false);
    private ISessionManager<Connection> sessionManager;
    private ChannelWrapper<Connection> channelWrapper;
    private boolean isLoopback;
    private volatile PingFuture pingFuture = null;
    private volatile ConnectionManager<Connection> localListenerManager;
    private boolean remoteKeyChanged;
    private final EndPointBase<Connection> endPointBaseConnection;
    private boolean closeAsap = false;
    private final AtomicLong aes_gcm_iv = new AtomicLong(0L);
    private final RmiBridge rmiBridge;
    private final Map<Integer, RemoteObject> proxyIdCache = new WeakHashMap<Integer, RemoteObject>(8);
    private final IntMap<RemoteObjectCallback> rmiRegistrationCallbacks = new IntMap();
    private int rmiRegistrationID = 0;

    public ConnectionImpl(Logger logger, EndPointBase endPointBaseConnection, RmiBridge rmiBridge) {
        this.logger = logger;
        this.endPointBaseConnection = endPointBaseConnection;
        this.rmiBridge = rmiBridge;
    }

    void init(ChannelWrapper channelWrapper, ConnectionManager<Connection> sessionManager) {
        this.sessionManager = sessionManager;
        this.channelWrapper = channelWrapper;
        this.remoteKeyChanged = this.channelWrapper instanceof ChannelNetworkWrapper ? ((ChannelNetworkWrapper)this.channelWrapper).remoteKeyChanged() : false;
        this.isLoopback = channelWrapper.isLoopback();
    }

    void prep() {
        if (this.channelWrapper != null) {
            this.channelWrapper.init();
        }
    }

    @Override
    public final ParametersWithIV getCryptoParameters() {
        return this.channelWrapper.cryptoParameters();
    }

    @Override
    public final long getNextGcmSequence() {
        return this.aes_gcm_iv.getAndIncrement();
    }

    @Override
    public boolean hasRemoteKeyChanged() {
        return this.remoteKeyChanged;
    }

    @Override
    public String getRemoteHost() {
        return this.channelWrapper.getRemoteHost();
    }

    @Override
    public boolean isLoopback() {
        return this.isLoopback;
    }

    @Override
    public EndPointBase<Connection> getEndPoint() {
        return this.endPointBaseConnection;
    }

    @Override
    public int id() {
        return this.channelWrapper.id();
    }

    @Override
    public String idAsHex() {
        return Integer.toHexString(this.channelWrapper.id());
    }

    public final void updatePingResponse(PingMessage ping) {
        if (this.pingFuture != null) {
            this.pingFuture.setSuccess(this, ping);
        }
    }

    @Override
    public final Ping ping() {
        PingFuture pingFuture2 = this.pingFuture;
        if (pingFuture2 != null && !pingFuture2.isSuccess()) {
            pingFuture2.cancel();
        }
        Promise newPromise = this.channelWrapper.getEventLoop().newPromise();
        this.pingFuture = new PingFuture((Promise<PingTuple<? extends Connection>>)newPromise);
        PingMessage ping = new PingMessage();
        ping.id = this.pingFuture.getId();
        this.ping0(ping);
        return this.pingFuture;
    }

    public final void ping0(PingMessage ping) {
        if (this.channelWrapper.udp() != null) {
            this.UDP(ping).flush();
        } else {
            this.TCP(ping).flush();
        }
    }

    public final int getLastRoundTripTime() {
        PingFuture pingFuture2 = this.pingFuture;
        if (pingFuture2 != null) {
            return pingFuture2.getResponse();
        }
        return -1;
    }

    @Override
    public final boolean hasUDP() {
        return this.channelWrapper.udp() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (this.writeSignalNeeded.getAndSet(false)) {
            Object object = this.writeLock;
            synchronized (object) {
                this.needsLock.set(false);
                this.writeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlBackPressure(ConnectionPoint c) {
        while (!c.isWritable()) {
            this.needsLock.set(true);
            this.writeSignalNeeded.set(true);
            Object object = this.writeLock;
            synchronized (object) {
                if (this.needsLock.get()) {
                    try {
                        this.writeLock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public final ConnectionBridge send() {
        return this;
    }

    @Override
    public final void self(Object message) {
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Sending LOCAL {}", message);
        }
        this.sessionManager.onMessage(this, message);
    }

    final ConnectionPoint TCP_backpressure(Object message) {
        Logger logger2 = this.logger;
        if (!this.closeInProgress.get()) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("Sending TCP {}", message);
            }
            ConnectionPointWriter tcp = this.channelWrapper.tcp();
            this.controlBackPressure(tcp);
            tcp.write(message);
            return tcp;
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("writing TCP while closed: {}", message);
        }
        return ChannelNull.get();
    }

    @Override
    public final ConnectionPoint TCP(Object message) {
        Logger logger2 = this.logger;
        if (!this.closeInProgress.get()) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("Sending TCP {}", message);
            }
            ConnectionPointWriter tcp = this.channelWrapper.tcp();
            tcp.write(message);
            return tcp;
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("writing TCP while closed: {}", message);
        }
        return ChannelNull.get();
    }

    final ConnectionPoint UDP_backpressure(Object message) {
        Logger logger2 = this.logger;
        if (!this.closeInProgress.get()) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("Sending UDP {}", message);
            }
            ConnectionPointWriter udp = this.channelWrapper.udp();
            this.controlBackPressure(udp);
            udp.write(message);
            return udp;
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("writing UDP while closed: {}", message);
        }
        return ChannelNull.get();
    }

    @Override
    public ConnectionPoint UDP(Object message) {
        Logger logger2 = this.logger;
        if (!this.closeInProgress.get()) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("Sending UDP {}", message);
            }
            ConnectionPointWriter udp = this.channelWrapper.udp();
            udp.write(message);
            return udp;
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("writing UDP while closed: {}", message);
        }
        return ChannelNull.get();
    }

    @Override
    public final void flush() {
        this.channelWrapper.flush();
    }

    public final IdleBridge sendOnIdle(IdleSender sender) {
        return new IdleSenderFactory(this, sender);
    }

    @Override
    public final IdleBridge sendOnIdle(Object message) {
        return new IdleSenderFactory(this, message);
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent && ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            this.sessionManager.onIdle(this);
        }
        super.userEventTriggered(context, event);
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        this.channelRead(message);
        ReferenceCountUtil.release((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(Object object) throws Exception {
        this.messageInProgress.set(true);
        this.sessionManager.onMessage(this, object);
        this.messageInProgress.set(false);
        if (this.closeInProgress.get()) {
            Object object2 = this.messageInProgressLock;
            synchronized (object2) {
                this.messageInProgressLock.notifyAll();
            }
        }
        if (this.closeAsap) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Channel channel;
        Class<?> channelClass;
        boolean isTCP;
        if (this.messageInProgress.get()) {
            Object object = this.messageInProgressLock;
            synchronized (object) {
                try {
                    this.messageInProgressLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        boolean bl = isTCP = (channelClass = (channel = context.channel()).getClass()) == NioSocketChannel.class || channelClass == EpollSocketChannel.class;
        if (this.logger.isInfoEnabled()) {
            String type = isTCP ? "TCP" : (channelClass == NioDatagramChannel.class || channelClass == EpollDatagramChannel.class ? "UDP" : (channelClass == LocalChannel.class ? "LOCAL" : "UNKNOWN"));
            this.logger.info("Closed remote {} connection: {}", (Object)type, (Object)channel.remoteAddress().toString());
        }
        if (isTCP || channelClass == LocalChannel.class) {
            this.sessionManager.onDisconnected(this);
            this.close();
        }
        Object object = this.closeInProgressLock;
        synchronized (object) {
            this.alreadyClosed.set(true);
            this.closeInProgressLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.closeInProgress.compareAndSet(false, true)) {
            int idleTimeoutMs = this.endPointBaseConnection.getIdleTimeout();
            if (idleTimeoutMs == 0) {
                idleTimeoutMs = 2000;
            }
            Object object = this.messageInProgressLock;
            synchronized (object) {
                if (this.messageInProgress.get()) {
                    try {
                        this.messageInProgressLock.wait(idleTimeoutMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.channelWrapper.flush();
            this.channelWrapper.close(this, this.sessionManager);
            PingFuture pingFuture2 = this.pingFuture;
            if (pingFuture2 != null) {
                pingFuture2.cancel();
            }
            this.pingFuture = null;
            Object object2 = this.closeInProgressLock;
            synchronized (object2) {
                if (!this.alreadyClosed.get()) {
                    try {
                        this.closeInProgressLock.wait(idleTimeoutMs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public final void closeAsap() {
        this.closeAsap = true;
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        if (!(cause instanceof IOException)) {
            this.logger.error("Unexpected exception while receiving data from {}", (Object)channel.remoteAddress(), (Object)cause);
            if (channel.isOpen()) {
                channel.close();
            }
        } else {
            this.logger.error("Unexpected exception while communicating with {}!", (Object)channel.remoteAddress(), (Object)cause);
        }
    }

    @Override
    public final Listeners listeners() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners add(Listener listener) {
        if (this.endPointBaseConnection instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager == null) {
                    this.localListenerManager = ((EndPointServer)this.endPointBaseConnection).addListenerManager(this);
                }
                this.localListenerManager.add(listener);
            }
        } else {
            this.endPointBaseConnection.listeners().add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners remove(Listener listener) {
        if (this.endPointBaseConnection instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.remove(listener);
                    if (!this.localListenerManager.hasListeners()) {
                        ((EndPointServer)this.endPointBaseConnection).removeListenerManager(this);
                    }
                }
            }
        } else {
            this.endPointBaseConnection.listeners().remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners removeAll() {
        if (this.endPointBaseConnection instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.removeAll();
                    this.localListenerManager = null;
                    ((EndPointServer)this.endPointBaseConnection).removeListenerManager(this);
                }
            }
        } else {
            this.endPointBaseConnection.listeners().removeAll();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners removeAll(Class<?> classType) {
        if (this.endPointBaseConnection instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.removeAll(classType);
                    if (!this.localListenerManager.hasListeners()) {
                        this.localListenerManager = null;
                        ((EndPointServer)this.endPointBaseConnection).removeListenerManager(this);
                    }
                }
            }
        } else {
            this.endPointBaseConnection.listeners().removeAll(classType);
        }
        return this;
    }

    public String toString() {
        return this.channelWrapper.toString();
    }

    public int hashCode() {
        return this.id();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionImpl other = (ConnectionImpl)obj;
        return !(this.channelWrapper == null ? other.channelWrapper != null : !this.channelWrapper.equals(other.channelWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForRmi(int connectionTimeout) {
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            try {
                this.rmiRegistrationCallbacks.wait(connectionTimeout);
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupted waiting for RMI to finish.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean rmiCallbacksIsEmpty() {
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            return this.rmiRegistrationCallbacks.size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rmiCallbacksNotify() {
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            this.rmiRegistrationCallbacks.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmiCallbacksNotifyIfEmpty() {
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            if (this.rmiRegistrationCallbacks.size == 0) {
                this.rmiRegistrationCallbacks.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <Iface> void getRemoteObject(Class<Iface> interfaceClass, RemoteObjectCallback<Iface> callback) throws IOException {
        RmiRegistration message;
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("Cannot create a proxy for RMI access. It must be an interface.");
        }
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            int nextRmiID = this.rmiRegistrationID++;
            this.rmiRegistrationCallbacks.put(nextRmiID, callback);
            message = new RmiRegistration(interfaceClass, nextRmiID);
        }
        this.TCP(message).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <Iface> void getRemoteObject(int objectId, RemoteObjectCallback<Iface> callback) throws IOException {
        RmiRegistration message;
        IntMap<RemoteObjectCallback> intMap = this.rmiRegistrationCallbacks;
        synchronized (intMap) {
            int nextRmiID = this.rmiRegistrationID++;
            this.rmiRegistrationCallbacks.put(nextRmiID, callback);
            message = new RmiRegistration(objectId, nextRmiID);
        }
        this.TCP(message).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerInternal(ConnectionImpl connection, RmiRegistration remoteRegistration) {
        Class<?> interfaceClass = remoteRegistration.interfaceClass;
        int rmiID = remoteRegistration.rmiID;
        if (interfaceClass != null) {
            CryptoSerializationManager manager = this.getEndPoint().serializationManager;
            KryoExtra kryo = manager.takeKryo();
            Registration registration = kryo.getRegistration(interfaceClass);
            if (registration == null) {
                manager.returnKryo(kryo);
                this.logger.error("Error getting RMI class interface for " + interfaceClass);
                connection.TCP(new RmiRegistration(rmiID)).flush();
                return;
            }
            Class<?> implementationClass = manager.getRmiImpl(registration.getId());
            if (implementationClass == null) {
                manager.returnKryo(kryo);
                this.logger.error("Error getting RMI class implementation for " + interfaceClass);
                connection.TCP(new RmiRegistration(rmiID)).flush();
                return;
            }
            try {
                ClassObject remoteClassObject;
                Object remotePrimaryObject = kryo.newInstance(implementationClass);
                manager.returnKryo(kryo);
                this.rmiBridge.register(this.rmiBridge.nextObjectId(), remotePrimaryObject);
                LinkedList<ClassObject> remoteClasses = new LinkedList<ClassObject>();
                remoteClasses.add(new ClassObject(implementationClass, remotePrimaryObject));
                while ((remoteClassObject = (ClassObject)remoteClasses.pollFirst()) != null) {
                    for (Field field : remoteClassObject.clazz.getDeclaredFields()) {
                        if (field.getAnnotation(Rmi.class) == null) continue;
                        boolean prev = field.isAccessible();
                        field.setAccessible(true);
                        Object o = field.get(remoteClassObject.object);
                        field.setAccessible(prev);
                        Class<?> type = field.getType();
                        this.rmiBridge.register(this.rmiBridge.nextObjectId(), o);
                        remoteClasses.offerLast(new ClassObject(type, o));
                    }
                }
                connection.TCP(new RmiRegistration(remotePrimaryObject, rmiID)).flush();
            }
            catch (Exception e) {
                this.logger.error("Error registering RMI class " + implementationClass, (Throwable)e);
                connection.TCP(new RmiRegistration(rmiID)).flush();
            }
        } else if (remoteRegistration.remoteObjectId > 0) {
            Object object = this.getImplementationObject(remoteRegistration.remoteObjectId);
            if (object != null) {
                connection.TCP(new RmiRegistration(object, rmiID)).flush();
            } else {
                connection.TCP(new RmiRegistration(rmiID)).flush();
            }
        } else {
            RemoteObjectCallback callback;
            Object remoteObject = remoteRegistration.remoteObject;
            IntMap<RemoteObjectCallback> kryo = this.rmiRegistrationCallbacks;
            synchronized (kryo) {
                callback = this.rmiRegistrationCallbacks.remove(remoteRegistration.rmiID);
            }
            try {
                callback.created(remoteObject);
            }
            catch (Exception e) {
                this.logger.error("Error getting remote object " + remoteObject.getClass() + ", ID: " + rmiID, (Throwable)e);
            }
            this.rmiCallbacksNotifyIfEmpty();
        }
    }

    @Override
    public <T> int getRegisteredId(T object) {
        RmiBridge globalRmiBridge = this.endPointBaseConnection.globalRmiBridge;
        if (globalRmiBridge == null) {
            throw new NullPointerException("Unable to call 'getRegisteredId' when the globalRmiBridge is null!");
        }
        int object1 = globalRmiBridge.getRegisteredId(object);
        if (object1 == Integer.MAX_VALUE) {
            return this.rmiBridge.getRegisteredId(object);
        }
        return object1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteObject getProxyObject(int objectID, Class<?> type) {
        Map<Integer, RemoteObject> map = this.proxyIdCache;
        synchronized (map) {
            RemoteObject remoteObject = this.proxyIdCache.get(objectID);
            if (remoteObject == null) {
                remoteObject = this.rmiBridge.createProxyObject(this, objectID, type);
                this.proxyIdCache.put(objectID, remoteObject);
            }
            return remoteObject;
        }
    }

    @Override
    public Object getImplementationObject(int objectID) {
        if (RmiBridge.isGlobal(objectID)) {
            RmiBridge globalRmiBridge = this.endPointBaseConnection.globalRmiBridge;
            if (globalRmiBridge == null) {
                throw new NullPointerException("Unable to call 'getRegisteredId' when the gloablRmiBridge is null!");
            }
            return globalRmiBridge.getRegisteredObject(objectID);
        }
        return this.rmiBridge.getRegisteredObject(objectID);
    }
}

