/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.Listener;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.bridge.ConnectionBridgeServer;
import dorkbox.network.connection.bridge.ConnectionExceptSpecifiedBridgeServer;
import dorkbox.network.connection.listenerManagement.OnConnectedManager;
import dorkbox.network.connection.listenerManagement.OnDisconnectedManager;
import dorkbox.network.connection.listenerManagement.OnIdleManager;
import dorkbox.network.connection.listenerManagement.OnMessageReceivedManager;
import dorkbox.util.ClassHelper;
import dorkbox.util.Property;
import dorkbox.util.collections.ConcurrentEntry;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager<C extends Connection>
implements Listeners,
ISessionManager<C>,
ConnectionPoint,
ConnectionBridgeServer<C>,
ConnectionExceptSpecifiedBridgeServer<C> {
    @Property
    public static final float LOAD_FACTOR = 0.8f;
    private final String loggerName;
    private final OnConnectedManager<C> onConnectedManager;
    private final OnDisconnectedManager<C> onDisconnectedManager;
    private final OnIdleManager<C> onIdleManager;
    private final OnMessageReceivedManager<C> onMessageReceivedManager;
    private volatile ConcurrentEntry<C> connectionsHead = null;
    private final IdentityMap<C, ConcurrentEntry> connectionEntries = new IdentityMap(32, 0.8f);
    private volatile IdentityMap<Connection, ConnectionManager<C>> localManagers = new IdentityMap(8, 0.8f);
    private final Object singleWriterLock2 = new Object();
    private final Object singleWriterLock3 = new Object();
    private static final AtomicReferenceFieldUpdater<ConnectionManager, IdentityMap> localManagersREF = AtomicReferenceFieldUpdater.newUpdater(ConnectionManager.class, IdentityMap.class, "localManagers");
    private static final AtomicReferenceFieldUpdater<ConnectionManager, ConcurrentEntry> connectionsREF = AtomicReferenceFieldUpdater.newUpdater(ConnectionManager.class, ConcurrentEntry.class, "connectionsHead");
    private final Class<?> baseClass;
    protected final Logger logger;
    private final AtomicBoolean hasAddedAtLeastOnce = new AtomicBoolean(false);
    final AtomicBoolean shutdown = new AtomicBoolean(false);

    ConnectionManager(String loggerName, Class<?> baseClass) {
        this.loggerName = loggerName;
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.baseClass = baseClass;
        this.onConnectedManager = new OnConnectedManager(this.logger);
        this.onDisconnectedManager = new OnDisconnectedManager(this.logger);
        this.onIdleManager = new OnIdleManager(this.logger);
        this.onMessageReceivedManager = new OnMessageReceivedManager(this.logger);
    }

    @Override
    public final Listeners add(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Class<?> clazz = listener.getClass();
        Class<?> genericClass = ClassHelper.getGenericParameterAsClassForSuperClass(clazz, 0);
        if (genericClass == this.baseClass || genericClass == null) {
            this.addListener0(listener);
            return this;
        }
        if (ClassHelper.hasInterface(Connection.class, genericClass) && !ClassHelper.hasParentClass(this.baseClass, genericClass)) {
            this.addListener0(listener);
            return this;
        }
        throw new IllegalArgumentException("Unable to add incompatible connection type as a listener! : " + this.baseClass);
    }

    private void addListener0(Listener listener) {
        boolean found = false;
        if (listener instanceof Listener.OnConnected) {
            this.onConnectedManager.add((Listener.OnConnected)listener);
            found = true;
        }
        if (listener instanceof Listener.OnDisconnected) {
            this.onDisconnectedManager.add((Listener.OnDisconnected)listener);
            found = true;
        }
        if (listener instanceof Listener.OnIdle) {
            this.onIdleManager.add((Listener.OnIdle)listener);
            found = true;
        }
        if (listener instanceof Listener.OnMessageReceived) {
            this.onMessageReceivedManager.add((Listener.OnMessageReceived)listener);
            found = true;
        }
        Logger logger2 = this.logger;
        if (!found) {
            logger2.error("No matching listener types. Unable to add listener: {}", (Object)listener.getClass().getName());
        } else {
            this.hasAddedAtLeastOnce.set(true);
            if (logger2.isTraceEnabled()) {
                logger2.trace("listener added: {}", (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public final Listeners remove(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        boolean found = false;
        if (listener instanceof Listener.OnConnected) {
            found = this.onConnectedManager.remove((Listener.OnConnected)listener);
        }
        if (listener instanceof Listener.OnDisconnected) {
            found |= this.onDisconnectedManager.remove((Listener.OnDisconnected)listener);
        }
        if (listener instanceof Listener.OnIdle) {
            found |= this.onIdleManager.remove((Listener.OnIdle)listener);
        }
        if (listener instanceof Listener.OnMessageReceived) {
            found |= this.onMessageReceivedManager.remove((Listener.OnMessageReceived)listener);
        }
        Logger logger2 = this.logger;
        if (!found) {
            logger2.error("No matching listener types. Unable to remove listener: {}", (Object)listener.getClass().getName());
        } else if (logger2.isTraceEnabled()) {
            logger2.trace("listener removed: {}", (Object)listener.getClass().getName());
        }
        return this;
    }

    @Override
    public final Listeners removeAll() {
        this.onMessageReceivedManager.removeAll();
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("ALL listeners removed !!");
        }
        return this;
    }

    @Override
    public final Listeners removeAll(Class<?> classType) {
        if (classType == null) {
            throw new IllegalArgumentException("classType cannot be null.");
        }
        Logger logger2 = this.logger;
        if (this.onMessageReceivedManager.removeAll(classType)) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("All listeners removed for type: {}", (Object)classType.getClass().getName());
            }
        } else {
            logger2.warn("No listeners found to remove for type: {}", (Object)classType.getClass().getName());
        }
        return this;
    }

    @Override
    public final void onMessage(C connection, Object message) {
        this.notifyOnMessage0(connection, message, false);
    }

    private boolean notifyOnMessage0(C connection, Object message, boolean foundListener) {
        foundListener |= this.onMessageReceivedManager.notifyReceived(connection, message, this.shutdown);
        IdentityMap localManagers = localManagersREF.get(this);
        ConnectionManager localManager = (ConnectionManager)localManagers.get(connection);
        if (localManager != null) {
            foundListener |= localManager.notifyOnMessage0(connection, message, foundListener);
        }
        if (foundListener) {
            connection.send().flush();
        } else if (this.logger.isErrorEnabled()) {
            this.logger.warn("----------- LISTENER NOT REGISTERED FOR TYPE: {}", (Object)message.getClass().getSimpleName());
        }
        return foundListener;
    }

    @Override
    public final void onIdle(C connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        boolean foundListener = this.onIdleManager.notifyIdle(connection, this.shutdown);
        if (foundListener) {
            connection.send().flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get(connection)) != null) {
            localManager.onIdle(connection);
        }
    }

    @Override
    public void onConnected(C connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        this.addConnection(connection);
        boolean foundListener = this.onConnectedManager.notifyConnected(connection, this.shutdown);
        if (foundListener) {
            connection.send().flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get(connection)) != null) {
            localManager.onConnected(connection);
        }
    }

    @Override
    public void onDisconnected(C connection) {
        IdentityMap localManagers;
        ConnectionManager localManager;
        boolean foundListener = this.onDisconnectedManager.notifyDisconnected(connection, this.shutdown);
        if (foundListener) {
            connection.send().flush();
        }
        if ((localManager = (ConnectionManager)(localManagers = localManagersREF.get(this)).get(connection)) != null) {
            localManager.onDisconnected(connection);
            this.removeListenerManager((Connection)connection);
        }
        this.removeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(C connection) {
        Object object = this.singleWriterLock2;
        synchronized (object) {
            ConcurrentEntry<C> head = connectionsREF.get(this);
            if (!this.connectionEntries.containsKey(connection)) {
                head = new ConcurrentEntry<C>(connection, head);
                this.connectionEntries.put(connection, head);
                connectionsREF.lazySet(this, head);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(C connection) {
        Object object = this.singleWriterLock2;
        synchronized (object) {
            ConcurrentEntry concurrentEntry = (ConcurrentEntry)this.connectionEntries.get(connection);
            if (concurrentEntry != null) {
                ConcurrentEntry head1 = connectionsREF.get(this);
                if (concurrentEntry == head1) {
                    head1 = head1.next();
                } else {
                    concurrentEntry.remove();
                }
                connectionsREF.lazySet(this, head1);
                this.connectionEntries.remove(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<C> getConnections() {
        Object object = this.singleWriterLock2;
        synchronized (object) {
            IdentityMap.Keys keys = this.connectionEntries.keys();
            return keys.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ConnectionManager<C> addListenerManager(Connection connection) {
        Logger logger2;
        ConnectionManager<C> manager;
        boolean created = false;
        Object object = this.singleWriterLock3;
        synchronized (object) {
            IdentityMap localManagers = localManagersREF.get(this);
            manager = (ConnectionManager<C>)localManagers.get((Object)connection);
            if (manager == null) {
                created = true;
                manager = new ConnectionManager<C>(this.loggerName + "-" + connection.toString() + " Specific", this.baseClass);
                localManagers.put((Object)connection, manager);
                localManagersREF.lazySet(this, localManagers);
            }
        }
        if (created && (logger2 = this.logger).isTraceEnabled()) {
            logger2.trace("Connection specific Listener Manager added for connection: {}", (Object)connection);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeListenerManager(Connection connection) {
        Logger logger2;
        boolean wasRemoved = false;
        Object object = this.singleWriterLock3;
        synchronized (object) {
            IdentityMap localManagers = localManagersREF.get(this);
            ConnectionManager removed = (ConnectionManager)localManagers.remove((Object)connection);
            if (removed != null) {
                wasRemoved = true;
                localManagersREF.lazySet(this, localManagers);
            }
        }
        if (wasRemoved && (logger2 = this.logger).isTraceEnabled()) {
            logger2.trace("Connection specific Listener Manager removed for connection: {}", (Object)connection);
        }
    }

    public final C getConnection0() throws IOException {
        ConcurrentEntry head1 = connectionsREF.get(this);
        if (head1 != null) {
            return (C)((Connection)head1.getValue());
        }
        throw new IOException("Not connected to a remote computer. Unable to continue!");
    }

    final boolean hasListeners() {
        return this.hasAddedAtLeastOnce.get();
    }

    final void stop() {
        this.shutdown.set(true);
        this.closeConnections();
        this.onConnectedManager.clear();
        this.onDisconnectedManager.clear();
        this.onIdleManager.clear();
        this.onMessageReceivedManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeConnections() {
        Object object = this.singleWriterLock2;
        synchronized (object) {
            IdentityMap.Keys keys = this.connectionEntries.keys();
            for (Connection connection : keys) {
                connection.close();
            }
            this.connectionEntries.clear();
            this.connectionsHead = null;
        }
    }

    @Override
    public boolean isWritable() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public ConnectionExceptSpecifiedBridgeServer<C> except() {
        return this;
    }

    @Override
    public void flush() {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send().flush();
        }
    }

    @Override
    public ConnectionPoint TCP(C connection, Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            if (c == connection) continue;
            c.send().TCP(message);
        }
        return this;
    }

    @Override
    public ConnectionPoint UDP(C connection, Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            if (c == connection) continue;
            c.send().UDP(message);
        }
        return this;
    }

    @Override
    public void self(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            this.onMessage(c, message);
        }
    }

    @Override
    public ConnectionPoint TCP(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send().TCP(message);
        }
        return this;
    }

    @Override
    public ConnectionPoint UDP(Object message) {
        for (ConcurrentEntry current = connectionsREF.get(this); current != null; current = current.next()) {
            Connection c = (Connection)current.getValue();
            c.send().UDP(message);
        }
        return this;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return 0;
    }
}

