/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.IntMap;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.rmi.InvocationHandlerSerializer;
import dorkbox.network.rmi.InvocationResultSerializer;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.network.rmi.InvokeMethodSerializer;
import dorkbox.network.rmi.RemoteObjectSerializer;
import dorkbox.network.rmi.RmiRegistration;
import dorkbox.network.util.RmiSerializationManager;
import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import dorkbox.util.Property;
import dorkbox.util.serialization.ArraysAsListSerializer;
import dorkbox.util.serialization.EccPrivateKeySerializer;
import dorkbox.util.serialization.EccPublicKeySerializer;
import dorkbox.util.serialization.FieldAnnotationAwareSerializer;
import dorkbox.util.serialization.IesParametersSerializer;
import dorkbox.util.serialization.IesWithCipherParametersSerializer;
import dorkbox.util.serialization.IgnoreSerialization;
import dorkbox.util.serialization.UnmodifiableCollectionsSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoSerializationManager
implements dorkbox.network.util.CryptoSerializationManager,
RmiSerializationManager {
    private static final Logger logger = LoggerFactory.getLogger(CryptoSerializationManager.class);
    @Property
    public static boolean useUnsafeMemory = false;
    private static final String OBJECT_ID = "objectID";
    private boolean initialized = false;
    private final ObjectPool<KryoExtra> kryoPool;
    private final List<Object> classesToRegister = new ArrayList<Object>();
    private boolean usesRmi = false;
    private InvokeMethodSerializer methodSerializer = null;
    private Serializer<Object> invocationSerializer = null;
    private RemoteObjectSerializer remoteObjectSerializer;
    private final IntMap<Class<?>> rmiIdToImpl = new IntMap();
    private final IntMap<Class<?>> rmiIdToIface = new IntMap();
    private final IdentityMap<Class<?>, Class<?>> rmiIfacetoImpl = new IdentityMap();
    private final IdentityMap<Class<?>, Class<?>> rmiImplToIface = new IdentityMap();

    public static CryptoSerializationManager DEFAULT() {
        return CryptoSerializationManager.DEFAULT(true, true);
    }

    public static CryptoSerializationManager DEFAULT(boolean references, boolean registrationRequired) {
        ArrayList<Class<? extends Annotation>> marks = new ArrayList<Class<? extends Annotation>>();
        marks.add(IgnoreSerialization.class);
        FieldAnnotationAwareSerializer.Factory disregardingFactory = new FieldAnnotationAwareSerializer.Factory(marks, true);
        CryptoSerializationManager serializationManager = new CryptoSerializationManager(references, registrationRequired, disregardingFactory);
        serializationManager.register((Class)PingMessage.class);
        serializationManager.register((Class)byte[].class);
        serializationManager.register((Class)IESParameters.class, new IesParametersSerializer());
        serializationManager.register((Class)IESWithCipherParameters.class, new IesWithCipherParametersSerializer());
        serializationManager.register((Class)ECPublicKeyParameters.class, new EccPublicKeySerializer());
        serializationManager.register((Class)ECPrivateKeyParameters.class, new EccPrivateKeySerializer());
        serializationManager.register((Class)Registration.class);
        serializationManager.register((Class)ArrayList.class, (Serializer)new CollectionSerializer());
        serializationManager.register((Class)StackTraceElement.class);
        serializationManager.register((Class)StackTraceElement[].class);
        serializationManager.register((Class)Arrays.asList("").getClass(), new ArraysAsListSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers(serializationManager);
        return serializationManager;
    }

    public CryptoSerializationManager(final boolean references, final boolean registrationRequired, final SerializerFactory factory) {
        this.kryoPool = ObjectPool.NonBlockingSoftReference((PoolableObject)new PoolableObject<KryoExtra>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public KryoExtra create() {
                CryptoSerializationManager cryptoSerializationManager = CryptoSerializationManager.this;
                synchronized (cryptoSerializationManager) {
                    KryoExtra kryo = new KryoExtra(CryptoSerializationManager.this);
                    boolean useAsm = !useUnsafeMemory;
                    kryo.getFieldSerializerConfig().setUseAsm(useAsm);
                    kryo.setRegistrationRequired(registrationRequired);
                    kryo.setReferences(references);
                    if (CryptoSerializationManager.this.usesRmi) {
                        kryo.register(Class.class);
                        kryo.register(RmiRegistration.class);
                        kryo.register(InvokeMethod.class, CryptoSerializationManager.this.methodSerializer);
                        kryo.register(Object[].class);
                        InvocationResultSerializer resultSerializer = new InvocationResultSerializer(kryo);
                        resultSerializer.removeField(CryptoSerializationManager.OBJECT_ID);
                        kryo.register(InvokeMethodResult.class, (Serializer)resultSerializer);
                        kryo.register(InvocationHandler.class, CryptoSerializationManager.this.invocationSerializer);
                    }
                    for (Object clazz : CryptoSerializationManager.this.classesToRegister) {
                        Object classSerializer;
                        if (clazz instanceof Class) {
                            kryo.register((Class)clazz);
                            continue;
                        }
                        if (clazz instanceof ClassSerializer) {
                            classSerializer = (ClassSerializer)clazz;
                            kryo.register(((ClassSerializer)classSerializer).clazz, ((ClassSerializer)classSerializer).serializer);
                            continue;
                        }
                        if (clazz instanceof ClassSerializer2) {
                            classSerializer = (ClassSerializer2)clazz;
                            kryo.register(((ClassSerializer2)classSerializer).clazz, ((ClassSerializer2)classSerializer).serializer, ((ClassSerializer2)classSerializer).id);
                            continue;
                        }
                        if (clazz instanceof RemoteIfaceClass) {
                            RemoteIfaceClass remoteIfaceClass = (RemoteIfaceClass)clazz;
                            kryo.register(remoteIfaceClass.ifaceClass, CryptoSerializationManager.this.remoteObjectSerializer);
                            continue;
                        }
                        if (!(clazz instanceof RemoteImplClass)) continue;
                        RemoteImplClass remoteImplClass = (RemoteImplClass)clazz;
                        int id = kryo.register(remoteImplClass.implClass, CryptoSerializationManager.this.remoteObjectSerializer).getId();
                        CryptoSerializationManager.this.rmiIdToImpl.put(id, (Object)remoteImplClass.implClass);
                        CryptoSerializationManager.this.rmiIdToIface.put(id, (Object)remoteImplClass.ifaceClass);
                    }
                    if (factory != null) {
                        kryo.setDefaultSerializer(factory);
                    }
                    return kryo;
                }
            }
        });
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class) call.");
        } else {
            if (clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(clazz);
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz, Serializer<?> serializer) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class, Serializer) call.");
        } else {
            if (clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(new ClassSerializer(clazz, serializer));
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz, Serializer<?> serializer, int id) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class, Serializer, int) call.");
        } else {
            if (clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(new ClassSerializer2(clazz, serializer, id));
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager registerRmiInterface(Class<?> ifaceClass) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate registerRemote(Class, Class) call.");
            return this;
        }
        if (!ifaceClass.isInterface()) {
            throw new IllegalArgumentException("Cannot register an implementation for RMI access. It must be an interface.");
        }
        this.usesRmi = true;
        this.classesToRegister.add(new RemoteIfaceClass(ifaceClass));
        return this;
    }

    @Override
    public synchronized <Iface, Impl extends Iface> RmiSerializationManager registerRmiImplementation(Class<Iface> ifaceClass, Class<Impl> implClass) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate registerRemote(Class, Class) call.");
            return this;
        }
        this.usesRmi = true;
        this.classesToRegister.add(new RemoteImplClass(ifaceClass, implClass));
        Class a = (Class)this.rmiIfacetoImpl.put(ifaceClass, implClass);
        Class b = (Class)this.rmiImplToIface.put(implClass, ifaceClass);
        if (a != null || b != null) {
            throw new IllegalArgumentException("Unable to override interface (" + ifaceClass + ") and implementation (" + implClass + ") because they have already been overridden by something else. It is critical that they are both unique per JVM");
        }
        return this;
    }

    @Override
    public synchronized boolean initRmiSerialization() {
        if (!this.usesRmi) {
            return false;
        }
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate initRmiSerialization() call.");
            return true;
        }
        this.methodSerializer = new InvokeMethodSerializer();
        this.invocationSerializer = new InvocationHandlerSerializer(logger);
        this.remoteObjectSerializer = new RemoteObjectSerializer();
        return true;
    }

    @Override
    public synchronized void finishInit() {
        this.initialized = true;
        this.kryoPool.put((Object)this.takeKryo());
    }

    @Override
    public synchronized boolean initialized() {
        return this.initialized;
    }

    @Override
    public Class<?> getRmiIface(int objectId) {
        return (Class)this.rmiIdToIface.get(objectId);
    }

    @Override
    public Class<?> getRmiImpl(int objectId) {
        return (Class)this.rmiIdToImpl.get(objectId);
    }

    @Override
    public Class<?> getRmiImpl(Class<?> iface) {
        return (Class)this.rmiIfacetoImpl.get(iface);
    }

    @Override
    public Class<?> getRmiIface(Class<?> implementation) {
        return (Class)this.rmiImplToIface.get(implementation);
    }

    @Override
    public KryoExtra takeKryo() {
        return (KryoExtra)((Object)this.kryoPool.take());
    }

    @Override
    public void returnKryo(KryoExtra kryo) {
        this.kryoPool.put((Object)kryo);
    }

    public static boolean isEncrypted(ByteBuf buffer) {
        byte magicByte = buffer.getByte(buffer.readerIndex());
        return (magicByte & 2) == 2;
    }

    @Override
    public void writeFullClassAndObject(Logger logger, Output output, Object value) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        boolean prev = false;
        try {
            prev = kryo.isRegistrationRequired();
            kryo.setRegistrationRequired(false);
            kryo.writeClassAndObject(output, value);
        }
        catch (Exception ex) {
            String msg = "Unable to serialize buffer";
            if (logger != null) {
                logger.error("Unable to serialize buffer", (Throwable)ex);
            }
            throw new IOException("Unable to serialize buffer", ex);
        }
        finally {
            kryo.setRegistrationRequired(prev);
            this.kryoPool.put((Object)kryo);
        }
    }

    @Override
    public Object readFullClassAndObject(Logger logger, Input input) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        boolean prev = false;
        try {
            prev = kryo.isRegistrationRequired();
            kryo.setRegistrationRequired(false);
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        catch (Exception ex) {
            String msg = "Unable to deserialize buffer";
            if (logger != null) {
                logger.error("Unable to deserialize buffer", (Throwable)ex);
            }
            throw new IOException("Unable to deserialize buffer", ex);
        }
        finally {
            kryo.setRegistrationRequired(prev);
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(ByteBuf buffer, Object message) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            kryo.write(buffer, message);
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object read(ByteBuf buffer, int length) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            Object object = kryo.read(buffer);
            return object;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeWithCrypto(ConnectionImpl connection, ByteBuf buffer, Object message) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (connection.isLoopback()) {
                kryo.writeCompressed(connection, buffer, message);
            } else {
                kryo.writeCrypto(connection, buffer, message);
            }
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object readWithCrypto(ConnectionImpl connection, ByteBuf buffer, int length) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (connection.isLoopback()) {
                Object object = kryo.readCompressed(connection, buffer, length);
                return object;
            }
            Object object = kryo.readCrypto(connection, buffer, length);
            return object;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    private static class ClassSerializer {
        final Class<?> clazz;
        final Serializer<?> serializer;

        ClassSerializer(Class<?> clazz, Serializer<?> serializer) {
            this.clazz = clazz;
            this.serializer = serializer;
        }
    }

    private static class ClassSerializer2 {
        final Class<?> clazz;
        final Serializer<?> serializer;
        final int id;

        ClassSerializer2(Class<?> clazz, Serializer<?> serializer, int id) {
            this.clazz = clazz;
            this.serializer = serializer;
            this.id = id;
        }
    }

    private static class RemoteIfaceClass {
        private final Class<?> ifaceClass;

        RemoteIfaceClass(Class<?> ifaceClass) {
            this.ifaceClass = ifaceClass;
        }
    }

    private static class RemoteImplClass {
        private final Class<?> ifaceClass;
        private final Class<?> implClass;

        RemoteImplClass(Class<?> ifaceClass, Class<?> implClass) {
            this.ifaceClass = ifaceClass;
            this.implClass = implClass;
        }
    }
}

