/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.util.OS;
import dorkbox.util.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPoint {
    protected static final String shutdownHookName = "::SHUTDOWN_HOOK::";
    protected static final String stopTreadName = "::STOP_THREAD::";
    public static final String THREADGROUP_NAME = "(Netty)";
    @Property
    public static final int WRITE_BUFF_HIGH = 32768;
    @Property
    public static final int WRITE_BUFF_LOW = 8192;
    @Property
    public static int DEFAULT_THREAD_POOL_SIZE;
    @Property
    public static long maxShutdownWaitTimeInMilliSeconds;
    protected final Logger logger;
    protected final ThreadGroup threadGroup;
    protected final Class<? extends EndPoint> type;
    protected final Object shutdownInProgress = new Object();
    private final List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>(8);
    private final List<ChannelFuture> shutdownChannelList = new ArrayList<ChannelFuture>();
    private Thread shutdownHook;
    private final CountDownLatch blockUntilDone = new CountDownLatch(1);
    private AtomicBoolean stopCalled = new AtomicBoolean(false);

    public EndPoint(Class<? extends EndPoint> type) {
        this.type = type;
        SecurityManager s = System.getSecurityManager();
        this.threadGroup = new ThreadGroup(s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup(), type.getSimpleName() + " " + THREADGROUP_NAME);
        this.threadGroup.setDaemon(true);
        this.logger = LoggerFactory.getLogger((String)type.getSimpleName());
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                if (EndPoint.this.shouldShutdownHookRun()) {
                    EndPoint.this.stop();
                }
            }
        };
        this.shutdownHook.setName(shutdownHookName);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void manageForShutdown(ChannelFuture future) {
        List<ChannelFuture> list = this.shutdownChannelList;
        synchronized (list) {
            this.shutdownChannelList.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void manageForShutdown(EventLoopGroup loopGroup) {
        List<EventLoopGroup> list = this.eventLoopGroups;
        synchronized (list) {
            this.eventLoopGroups.add(loopGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownChannels() {
        List<ChannelFuture> list = this.shutdownChannelList;
        synchronized (list) {
            for (ChannelFuture f : this.shutdownChannelList) {
                Channel channel = f.channel();
                if (!channel.isOpen()) continue;
                channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
                Thread.yield();
            }
            this.shutdownChannelList.clear();
        }
    }

    protected final String stopWithErrorMessage(Logger logger2, String errorMessage, Throwable throwable) {
        if (logger2.isDebugEnabled() && throwable != null) {
            logger2.error(errorMessage, throwable.getCause());
        } else {
            logger2.error(errorMessage);
        }
        this.stop();
        return errorMessage;
    }

    protected boolean shouldShutdownHookRun() {
        return true;
    }

    public final void stop() {
        boolean inShutdownThread;
        if (!this.stopCalled.compareAndSet(false, true)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        boolean bl = inShutdownThread = !threadName.equals(shutdownHookName) && !threadName.equals(stopTreadName);
        if (!inShutdownThread) {
            this.stopInThread();
        } else {
            boolean isInEventLoop = false;
            block0: for (EventLoopGroup loopGroup : this.eventLoopGroups) {
                for (EventExecutor next : loopGroup) {
                    if (!next.inEventLoop()) continue;
                    isInEventLoop = true;
                    continue block0;
                }
            }
            if (!isInEventLoop) {
                this.stopInThread();
            } else {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        EndPoint.this.stopInThread();
                    }
                });
                thread.setDaemon(false);
                thread.setName(stopTreadName);
                thread.start();
            }
        }
    }

    protected void stopExtraActions() {
    }

    protected void shutdownChannelsPre() {
    }

    protected void stopExtraActionsInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInThread() {
        Object object = this.shutdownInProgress;
        synchronized (object) {
            LinkedList<Future> shutdownThreadList = new LinkedList<Future>();
            for (EventLoopGroup loopGroup : this.eventLoopGroups) {
                shutdownThreadList.add(loopGroup.shutdownGracefully(maxShutdownWaitTimeInMilliSeconds, maxShutdownWaitTimeInMilliSeconds * 4L, TimeUnit.MILLISECONDS));
                Thread.yield();
            }
            for (Future f : shutdownThreadList) {
                f.syncUninterruptibly();
                Thread.yield();
            }
            this.shutdownChannelsPre();
            this.shutdownChannels();
            this.logger.info("Stopping endpoint.");
            if (!Thread.currentThread().getName().equals(shutdownHookName)) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stopExtraActionsInternal();
            this.stopExtraActions();
            this.threadGroup.interrupt();
        }
        this.blockUntilDone.countDown();
    }

    public final void waitForShutdown() {
        try {
            this.blockUntilDone.await();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted while waiting for stop!");
        }
    }

    public String toString() {
        return "EndPoint [" + this.getName() + "]";
    }

    public String getName() {
        return this.type.getSimpleName();
    }

    static {
        try {
            System.setProperty("java.net.preferIPv4Stack", Boolean.TRUE.toString());
            System.setProperty("java.net.preferIPv6Addresses", Boolean.FALSE.toString());
            if (OS.javaVersion == 6 && PlatformDependent.hasUnsafe()) {
                PlatformDependent.newFixedMpscQueue((int)8);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
        maxShutdownWaitTimeInMilliSeconds = 2000L;
    }
}

