/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.Configuration;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionManager;
import dorkbox.network.connection.CryptoSerializationManager;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.PropertyStore;
import dorkbox.network.connection.RegisterRmiSystemListener;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.bridge.ConnectionBridgeBase;
import dorkbox.network.connection.ping.PingSystemListener;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelLocalWrapper;
import dorkbox.network.connection.wrapper.ChannelNetworkWrapper;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.pipeline.KryoEncoder;
import dorkbox.network.pipeline.KryoEncoderCrypto;
import dorkbox.network.rmi.RmiBridge;
import dorkbox.network.store.NullSettingsStore;
import dorkbox.network.store.SettingsStore;
import dorkbox.util.Property;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.entropy.Entropy;
import dorkbox.util.exceptions.InitializationException;
import dorkbox.util.exceptions.SecurityException;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;

public abstract class EndPointBase<C extends Connection>
extends EndPoint {
    public static final String LOCAL_CHANNEL = "local_channel";
    @Property
    public static int udpMaxSize = 508;
    protected final ConnectionManager<C> connectionManager;
    protected final dorkbox.network.util.CryptoSerializationManager serializationManager;
    protected final RegistrationWrapper<C> registrationWrapper;
    final ECPrivateKeyParameters privateKey;
    final ECPublicKeyParameters publicKey;
    final SecureRandom secureRandom;
    final RmiBridge globalRmiBridge;
    private final Executor rmiExecutor;
    private final boolean rmiEnabled;
    SettingsStore propertyStore;
    boolean disableRemoteKeyValidation;
    private volatile int idleTimeoutMs = 0;
    private AtomicBoolean isConnected = new AtomicBoolean(false);

    public EndPointBase(Class<? extends EndPointBase> type, Configuration config) throws InitializationException, SecurityException, IOException {
        super(type);
        if (config.host != null && (config.host.equals("localhost") || config.host.startsWith("127."))) {
            config.host = NetUtil.LOCALHOST.getHostAddress();
        }
        this.serializationManager = config.serialization != null ? config.serialization : CryptoSerializationManager.DEFAULT();
        this.rmiEnabled = this.serializationManager.initRmiSerialization();
        this.rmiExecutor = config.rmiExecutor;
        this.registrationWrapper = new RegistrationWrapper(this, this.logger, new KryoEncoder(this.serializationManager), new KryoEncoderCrypto(this.serializationManager));
        this.propertyStore = config.settingsStore == null ? new PropertyStore() : config.settingsStore;
        this.propertyStore.init(this.serializationManager, null);
        config.settingsStore = null;
        if (!(this.propertyStore instanceof NullSettingsStore)) {
            ECPrivateKeyParameters privateKey = this.propertyStore.getPrivateKey();
            ECPublicKeyParameters publicKey = this.propertyStore.getPublicKey();
            if (privateKey == null || publicKey == null) {
                try {
                    byte[] seedBytes = Entropy.get("There are no ECC keys for the " + type.getSimpleName() + " yet");
                    SecureRandom secureRandom = new SecureRandom(seedBytes);
                    secureRandom.nextBytes(seedBytes);
                    this.logger.debug("Now generating ECC (curve25519) keys. Please wait!");
                    AsymmetricCipherKeyPair generateKeyPair = CryptoECC.generateKeyPair("curve25519", secureRandom);
                    privateKey = (ECPrivateKeyParameters)generateKeyPair.getPrivate();
                    publicKey = (ECPublicKeyParameters)generateKeyPair.getPublic();
                    this.propertyStore.savePrivateKey(privateKey);
                    this.propertyStore.savePublicKey(publicKey);
                    this.logger.debug("Done with ECC keys!");
                }
                catch (Exception e) {
                    String message = "Unable to initialize/generate ECC keys. FORCED SHUTDOWN.";
                    this.logger.error(message);
                    throw new InitializationException(message);
                }
            }
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        } else {
            this.privateKey = null;
            this.publicKey = null;
        }
        this.secureRandom = new SecureRandom(this.propertyStore.getSalt());
        this.connectionManager = new ConnectionManager(type.getSimpleName(), this.connection0(null).getClass());
        this.connectionManager.add(new PingSystemListener());
        if (this.rmiEnabled) {
            this.connectionManager.add(new RegisterRmiSystemListener());
            this.globalRmiBridge = new RmiBridge(this.logger, config.rmiExecutor, true);
        } else {
            this.globalRmiBridge = null;
        }
        this.serializationManager.finishInit();
    }

    public void disableRemoteKeyValidation() {
        Logger logger2 = this.logger;
        if (this.isConnected()) {
            logger2.error("Cannot disable the remote key validation after this endpoint is connected!");
        } else {
            logger2.info("WARNING: Disabling remote key validation is a security risk!!");
            this.disableRemoteKeyValidation = true;
        }
    }

    public <S extends SettingsStore> S getPropertyStore() {
        return (S)this.propertyStore;
    }

    protected boolean registerNextProtocol0() {
        return true;
    }

    public int getIdleTimeout() {
        return this.idleTimeoutMs;
    }

    public void setIdleTimeout(int idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public final boolean isConnected() {
        return this.isConnected.get();
    }

    public dorkbox.network.util.CryptoSerializationManager getSerialization() {
        return this.serializationManager;
    }

    protected ConnectionImpl newConnection(Logger logger, EndPointBase<C> endPointBaseConnection, RmiBridge rmiBridge) {
        return new ConnectionImpl(logger, endPointBaseConnection, rmiBridge);
    }

    protected final Connection connection0(MetaChannel metaChannel) {
        ConnectionImpl connection;
        RmiBridge rmiBridge = null;
        if (metaChannel != null && this.rmiEnabled) {
            rmiBridge = new RmiBridge(this.logger, this.rmiExecutor, false);
        }
        if (metaChannel != null) {
            metaChannel.connection = connection = this.newConnection(this.logger, this, rmiBridge);
            ChannelWrapper wrapper = metaChannel.localChannel != null ? new ChannelLocalWrapper(metaChannel) : (this instanceof EndPointServer ? new ChannelNetworkWrapper(metaChannel, this.registrationWrapper) : new ChannelNetworkWrapper(metaChannel, null));
            connection.init(wrapper, this.connectionManager);
            if (rmiBridge != null) {
                connection.listeners().add(rmiBridge.getListener());
            }
        } else {
            connection = this.newConnection(null, null, null);
        }
        return connection;
    }

    void connectionConnected0(ConnectionImpl connection) {
        this.isConnected.set(true);
        connection.prep();
        this.connectionManager.onConnected(connection);
    }

    public final Listeners listeners() {
        return this.connectionManager;
    }

    public List<C> getConnections() {
        return this.connectionManager.getConnections();
    }

    public Collection<C> getConnectionsAs() {
        return this.connectionManager.getConnections();
    }

    public abstract ConnectionBridgeBase send();

    public void closeConnections() {
        Thread.yield();
        this.connectionManager.closeConnections();
        this.registrationWrapper.closeChannels(maxShutdownWaitTimeInMilliSeconds);
        this.isConnected.set(false);
    }

    @Override
    protected boolean shouldShutdownHookRun() {
        return this.connectionManager != null && !this.connectionManager.shutdown.get();
    }

    @Override
    protected void shutdownChannelsPre() {
        this.closeConnections();
        this.connectionManager.stop();
    }

    @Override
    protected void stopExtraActionsInternal() {
        this.propertyStore.close();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndPointBase other = (EndPointBase)obj;
        if (this.privateKey == null ? other.privateKey != null : !CryptoECC.compare(this.privateKey, other.privateKey)) {
            return false;
        }
        return !(this.publicKey == null ? other.publicKey != null : !CryptoECC.compare(this.publicKey, other.publicKey));
    }

    public <T> int createGlobalObject(T globalObject) {
        int globalObjectId = this.globalRmiBridge.nextObjectId();
        this.globalRmiBridge.register(globalObjectId, globalObject);
        return globalObjectId;
    }
}

