/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.Client;
import dorkbox.network.Configuration;
import dorkbox.network.connection.BootstrapWrapper;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.Ping;
import dorkbox.network.connection.bridge.ConnectionBridge;
import dorkbox.util.exceptions.InitializationException;
import dorkbox.util.exceptions.SecurityException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class EndPointClient<C extends Connection>
extends EndPointBase<C>
implements Runnable {
    protected C connection;
    protected final Object registrationLock = new Object();
    protected final Object bootstrapLock = new Object();
    protected List<BootstrapWrapper> bootstraps = new LinkedList<BootstrapWrapper>();
    protected Iterator<BootstrapWrapper> bootstrapIterator;
    protected volatile int connectionTimeout = 5000;
    protected volatile boolean registrationComplete = false;
    private volatile boolean rmiInitializationComplete = false;
    private volatile ConnectionBridge connectionBridgeFlushAlways;

    public EndPointClient(Configuration config) throws InitializationException, SecurityException, IOException {
        super(Client.class, config);
    }

    protected void registerNextProtocol() {
        this.registrationComplete = false;
        this.bootstrapIterator = this.bootstraps.iterator();
        this.startProtocolRegistration();
    }

    private void startProtocolRegistration() {
        new Thread((Runnable)this, "Bootstrap registration").start();
    }

    private boolean isRegistrationComplete() {
        return !this.bootstrapIterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            ChannelFuture future;
            if (this.isRegistrationComplete()) {
                return;
            }
            BootstrapWrapper bootstrapWrapper = this.bootstrapIterator.next();
            if (this.connectionTimeout != 0) {
                bootstrapWrapper.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout);
            }
            Logger logger2 = this.logger;
            try {
                future = bootstrapWrapper.bootstrap.connect();
                future.await();
            }
            catch (Exception e) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not connect to the " + bootstrapWrapper.type + " server at " + bootstrapWrapper.address + " on port: " + bootstrapWrapper.port, e);
                throw new IllegalArgumentException(errorMessage);
            }
            if (!future.isSuccess()) {
                String errorMessage = this.stopWithErrorMessage(logger2, "Could not connect to the " + bootstrapWrapper.type + " server at " + bootstrapWrapper.address + " on port: " + bootstrapWrapper.port, future.cause());
                throw new IllegalArgumentException(errorMessage);
            }
            if (logger2.isTraceEnabled()) {
                logger2.trace("Waiting for registration from server.");
            }
            this.manageForShutdown(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean registerNextProtocol0() {
        Object object = this.bootstrapLock;
        synchronized (object) {
            this.registrationComplete = this.isRegistrationComplete();
            if (!this.registrationComplete) {
                this.startProtocolRegistration();
            }
            this.bootstrapIterator = null;
        }
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Registered protocol from server.");
        }
        return this.registrationComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void connectionConnected0(final ConnectionImpl connection) {
        super.connectionConnected0(connection);
        this.connectionBridgeFlushAlways = new ConnectionBridge(){

            @Override
            public void self(Object message) {
                connection.self(message);
                this.flush();
            }

            @Override
            public ConnectionPoint TCP(Object message) {
                ConnectionPoint tcp = connection.TCP_backpressure(message);
                tcp.flush();
                return tcp;
            }

            @Override
            public ConnectionPoint UDP(Object message) {
                ConnectionPoint udp = connection.UDP_backpressure(message);
                udp.flush();
                return udp;
            }

            @Override
            public Ping ping() {
                Ping ping = connection.ping();
                this.flush();
                return ping;
            }

            @Override
            public void flush() {
                connection.flush();
            }
        };
        this.connection = connection;
        this.rmiInitializationComplete = connection.rmiCallbacksIsEmpty();
        Object object = this.registrationLock;
        synchronized (object) {
            this.registrationLock.notify();
        }
    }

    protected void waitForRmi(int connectionTimeout) {
        if (!this.rmiInitializationComplete && this.connection instanceof ConnectionImpl) {
            ((ConnectionImpl)this.connection).waitForRmi(connectionTimeout);
        }
    }

    @Override
    public ConnectionBridge send() {
        return this.connectionBridgeFlushAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnections() {
        super.closeConnections();
        this.shutdownChannels();
        this.registrationComplete = true;
        Object object = this.registrationLock;
        synchronized (object) {
            this.registrationLock.notify();
        }
        this.registrationComplete = false;
        if (this.connection instanceof ConnectionImpl) {
            ((ConnectionImpl)this.connection).rmiCallbacksNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortRegistration() {
        Object object = this.registrationLock;
        synchronized (object) {
            this.registrationLock.notify();
        }
        if (this.connection instanceof ConnectionImpl) {
            ((ConnectionImpl)this.connection).rmiCallbacksNotify();
        }
        this.stop();
    }
}

