/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import com.esotericsoftware.kryo.util.ObjectMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.EndPointClient;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.UdpServer;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandler;
import dorkbox.network.pipeline.KryoEncoder;
import dorkbox.network.pipeline.KryoEncoderCrypto;
import dorkbox.util.RandomUtil;
import dorkbox.util.collections.IntMap;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.exceptions.SecurityException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;

public class RegistrationWrapper<C extends Connection>
implements UdpServer {
    private final Logger logger;
    private final KryoEncoder kryoEncoder;
    private final KryoEncoderCrypto kryoEncoderCrypto;
    private final EndPointBase<C> endPointBaseConnection;
    private final ReentrantLock channelMapLock = new ReentrantLock();
    private final IntMap<MetaChannel> channelMap = new IntMap();
    private volatile ObjectMap<InetSocketAddress, ConnectionImpl> udpRemoteMap;
    private final Object singleWriterLock1 = new Object();
    private static final AtomicReferenceFieldUpdater<RegistrationWrapper, ObjectMap> udpRemoteMapREF = AtomicReferenceFieldUpdater.newUpdater(RegistrationWrapper.class, ObjectMap.class, "udpRemoteMap");

    public RegistrationWrapper(EndPointBase<C> endPointBaseConnection, Logger logger, KryoEncoder kryoEncoder, KryoEncoderCrypto kryoEncoderCrypto) {
        this.endPointBaseConnection = endPointBaseConnection;
        this.logger = logger;
        this.kryoEncoder = kryoEncoder;
        this.kryoEncoderCrypto = kryoEncoderCrypto;
        this.udpRemoteMap = endPointBaseConnection instanceof EndPointServer ? new ObjectMap(32, 0.8f) : null;
    }

    public boolean rmiEnabled() {
        return this.endPointBaseConnection.globalRmiBridge != null;
    }

    public KryoEncoder getKryoEncoder() {
        return this.kryoEncoder;
    }

    public KryoEncoderCrypto getKryoEncoderCrypto() {
        return this.kryoEncoderCrypto;
    }

    private IntMap<MetaChannel> getAndLockChannelMap() {
        this.channelMapLock.lock();
        return this.channelMap;
    }

    private void releaseChannelMap() {
        this.channelMapLock.unlock();
    }

    public int getIdleTimeout() {
        return this.endPointBaseConnection.getIdleTimeout();
    }

    public boolean registerNextProtocol0() {
        return this.endPointBaseConnection.registerNextProtocol0();
    }

    public void connectionConnected0(ConnectionImpl networkConnection) {
        this.endPointBaseConnection.connectionConnected0(networkConnection);
    }

    public Connection connection0(MetaChannel metaChannel) {
        return this.endPointBaseConnection.connection0(metaChannel);
    }

    public SecureRandom getSecureRandom() {
        return this.endPointBaseConnection.secureRandom;
    }

    public ECPublicKeyParameters getPublicKey() {
        return this.endPointBaseConnection.publicKey;
    }

    public CipherParameters getPrivateKey() {
        return this.endPointBaseConnection.privateKey;
    }

    public boolean validateRemoteAddress(InetSocketAddress tcpRemoteServer, ECPublicKeyParameters publicKey) throws SecurityException {
        InetAddress address = tcpRemoteServer.getAddress();
        byte[] hostAddress = address.getAddress();
        ECPublicKeyParameters savedPublicKey = this.endPointBaseConnection.propertyStore.getRegisteredServerKey(hostAddress);
        Logger logger2 = this.logger;
        if (savedPublicKey == null) {
            if (logger2.isDebugEnabled()) {
                logger2.debug("Adding new remote IP address key for {}", (Object)address.getHostAddress());
            }
            this.endPointBaseConnection.propertyStore.addRegisteredServerKey(hostAddress, publicKey);
        } else if (!CryptoECC.compare(publicKey, savedPublicKey)) {
            String byAddress;
            try {
                byAddress = InetAddress.getByAddress(hostAddress).getHostAddress();
            }
            catch (UnknownHostException e) {
                byAddress = "Unknown Address";
            }
            if (this.endPointBaseConnection.disableRemoteKeyValidation) {
                logger2.warn("Invalid or non-matching public key from remote server. Their public key has changed. To fix, remove entry for: {}", (Object)byAddress);
                return true;
            }
            logger2.error("Invalid or non-matching public key from remote server. Their public key has changed. To fix, remove entry for: {}", (Object)byAddress);
            return false;
        }
        return true;
    }

    public void removeRegisteredServerKey(byte[] hostAddress) throws SecurityException {
        ECPublicKeyParameters savedPublicKey = this.endPointBaseConnection.propertyStore.getRegisteredServerKey(hostAddress);
        if (savedPublicKey != null) {
            Logger logger2 = this.logger;
            if (logger2.isDebugEnabled()) {
                logger2.debug("Deleting remote IP address key {}.{}.{}.{}", new Object[]{hostAddress[0], hostAddress[1], hostAddress[2], hostAddress[3]});
            }
            this.endPointBaseConnection.propertyStore.removeRegisteredServerKey(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerServerUDP(MetaChannel metaChannel) {
        if (metaChannel != null && metaChannel.udpRemoteAddress != null) {
            Object object = this.singleWriterLock1;
            synchronized (object) {
                ObjectMap udpRemoteMap = udpRemoteMapREF.get(this);
                udpRemoteMap.put((Object)metaChannel.udpRemoteAddress, (Object)metaChannel.connection);
                udpRemoteMapREF.lazySet(this, udpRemoteMap);
            }
            this.logger.info("Connected to remote UDP connection. [{} <== {}]", (Object)metaChannel.udpChannel.localAddress(), (Object)metaChannel.udpRemoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unRegisterServerUDP(InetSocketAddress udpRemoteAddress) {
        if (udpRemoteAddress != null) {
            Object object = this.singleWriterLock1;
            synchronized (object) {
                ObjectMap udpRemoteMap = udpRemoteMapREF.get(this);
                udpRemoteMap.remove((Object)udpRemoteAddress);
                udpRemoteMapREF.lazySet(this, udpRemoteMap);
            }
            this.logger.info("Closed remote UDP connection: {}", (Object)udpRemoteAddress);
        }
    }

    @Override
    public ConnectionImpl getServerUDP(InetSocketAddress udpRemoteAddress) {
        if (udpRemoteAddress != null) {
            ObjectMap udpRemoteMap = udpRemoteMapREF.get(this);
            return (ConnectionImpl)udpRemoteMap.get((Object)udpRemoteAddress);
        }
        return null;
    }

    public void abortRegistrationIfClient() {
        if (this.endPointBaseConnection instanceof EndPointClient) {
            ((EndPointClient)this.endPointBaseConnection).abortRegistration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(int channelHashCodeOrId, MetaChannel metaChannel) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            channelMap.put(channelHashCodeOrId, metaChannel);
        }
        finally {
            this.releaseChannelMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaChannel removeChannel(int channelHashCodeOrId) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            MetaChannel metaChannel = channelMap.remove(channelHashCodeOrId);
            return metaChannel;
        }
        finally {
            this.releaseChannelMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaChannel getChannel(int channelHashCodeOrId) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            MetaChannel metaChannel = channelMap.get(channelHashCodeOrId);
            return metaChannel;
        }
        finally {
            this.releaseChannelMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannels(long maxShutdownWaitTimeInMilliSeconds) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            IntMap.Entries<MetaChannel> entries = channelMap.entries();
            while (entries.hasNext()) {
                MetaChannel metaChannel = (MetaChannel)((IntMap.Entry)entries.next()).value;
                metaChannel.close(maxShutdownWaitTimeInMilliSeconds);
                Thread.yield();
            }
            channelMap.clear();
        }
        finally {
            this.releaseChannelMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaChannel closeChannel(Channel channel, long maxShutdownWaitTimeInMilliSeconds) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            IntMap.Entries<MetaChannel> entries = channelMap.entries();
            while (entries.hasNext()) {
                MetaChannel metaChannel = (MetaChannel)((IntMap.Entry)entries.next()).value;
                if (metaChannel.localChannel != channel && metaChannel.tcpChannel != channel && metaChannel.udpChannel != channel) continue;
                entries.remove();
                metaChannel.close(maxShutdownWaitTimeInMilliSeconds);
                MetaChannel metaChannel2 = metaChannel;
                return metaChannel2;
            }
        }
        finally {
            this.releaseChannelMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupChannels(RegistrationRemoteHandler<C> handler, MetaChannel metaChannel) {
        boolean registerServer = false;
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            channelMap.remove(metaChannel.tcpChannel.hashCode());
            channelMap.remove(metaChannel.connectionID);
            ChannelPipeline pipeline = metaChannel.tcpChannel.pipeline();
            pipeline.remove(handler);
            if (metaChannel.udpChannel != null) {
                if (metaChannel.udpRemoteAddress == null) {
                    channelMap.remove(metaChannel.udpChannel.hashCode());
                } else {
                    registerServer = true;
                }
            }
        }
        finally {
            this.releaseChannelMap();
        }
        return registerServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer initializeChannel(MetaChannel metaChannel) {
        Integer connectionID = RandomUtil.int_();
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            while (channelMap.containsKey(connectionID)) {
                connectionID = RandomUtil.int_();
            }
            metaChannel.connectionID = connectionID;
            channelMap.put(connectionID, metaChannel);
        }
        finally {
            this.releaseChannelMap();
        }
        return connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean associateChannels(Channel channel, InetAddress remoteAddress) {
        boolean success = false;
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            IntMap.Entries<MetaChannel> entries = channelMap.entries();
            while (entries.hasNext()) {
                MetaChannel metaChannel = (MetaChannel)((IntMap.Entry)entries.next()).value;
                InetSocketAddress inetSocketAddress = (InetSocketAddress)metaChannel.tcpChannel.remoteAddress();
                InetAddress tcpRemoteServer = inetSocketAddress.getAddress();
                if (!RegistrationRemoteHandler.checkEqual(tcpRemoteServer, remoteAddress)) continue;
                channelMap.put(channel.hashCode(), metaChannel);
                metaChannel.udpChannel = channel;
                success = true;
                break;
            }
        }
        finally {
            this.releaseChannelMap();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaChannel getAssociatedChannel_UDP(InetAddress remoteAddress) {
        try {
            IntMap<MetaChannel> channelMap = this.getAndLockChannelMap();
            IntMap.Entries<MetaChannel> entries = channelMap.entries();
            while (entries.hasNext()) {
                MetaChannel metaChannel = (MetaChannel)((IntMap.Entry)entries.next()).value;
                if (metaChannel.udpChannel != null) continue;
                InetSocketAddress tcpRemote = (InetSocketAddress)metaChannel.tcpChannel.remoteAddress();
                InetAddress tcpRemoteAddress = tcpRemote.getAddress();
                if (RegistrationRemoteHandler.checkEqual(tcpRemoteAddress, remoteAddress)) {
                    MetaChannel metaChannel2 = metaChannel;
                    return metaChannel2;
                }
                MetaChannel metaChannel3 = null;
                return metaChannel3;
            }
        }
        finally {
            this.releaseChannelMap();
        }
        return null;
    }
}

