/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.idle;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.idle.IdleBridge;
import dorkbox.network.connection.idle.IdleListenerTCP;
import dorkbox.network.connection.idle.IdleListenerUDP;
import dorkbox.network.connection.idle.IdleObjectSender;
import dorkbox.network.connection.idle.IdleSender;

public class IdleSenderFactory<C extends Connection, M>
implements IdleBridge {
    private final ConnectionImpl connection;
    private final Object message;

    public IdleSenderFactory(ConnectionImpl connection, Object message) {
        this.connection = connection;
        this.message = message;
    }

    @Override
    public void TCP() {
        if (this.message instanceof IdleSender) {
            this.connection.listeners().add((IdleSender)this.message);
        } else {
            this.connection.listeners().add(new IdleObjectSender(new IdleListenerTCP(), this.message));
        }
    }

    @Override
    public void UDP() {
        if (this.message instanceof IdleSender) {
            this.connection.listeners().add((IdleSender)this.message);
        } else {
            this.connection.listeners().add(new IdleObjectSender(new IdleListenerUDP(), this.message));
        }
    }
}

