/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.idle;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.idle.IdleListener;
import dorkbox.network.connection.idle.IdleSender;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamSender<C extends Connection>
extends IdleSender<C, byte[]> {
    private final InputStream input;
    private final byte[] chunk;

    public InputStreamSender(IdleListener<C, byte[]> idleListener, InputStream input, int chunkSize) {
        super(idleListener);
        this.input = input;
        this.chunk = new byte[chunkSize];
    }

    @Override
    protected final byte[] next() throws IOException {
        int count;
        for (int total = 0; total < this.chunk.length; total += count) {
            count = this.input.read(this.chunk, total, this.chunk.length - total);
            if (count >= 0) continue;
            if (total == 0) {
                return null;
            }
            byte[] partial = new byte[total];
            System.arraycopy(this.chunk, 0, partial, 0, total);
            return this.onNext(partial);
        }
        return this.onNext(this.chunk);
    }

    protected abstract byte[] onNext(byte[] var1);
}

