/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.listenerManagement;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.Listener;
import dorkbox.util.collections.ConcurrentEntry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;

public final class OnConnectedManager<C extends Connection> {
    private final Logger logger;
    private final IdentityMap<Listener.OnConnected<C>, ConcurrentEntry> entries = new IdentityMap(32, 0.8f);
    private volatile ConcurrentEntry<Listener.OnConnected<C>> head = null;
    private final Object lock = new Object();
    private static final AtomicReferenceFieldUpdater<OnConnectedManager, ConcurrentEntry> REF = AtomicReferenceFieldUpdater.newUpdater(OnConnectedManager.class, ConcurrentEntry.class, "head");

    public OnConnectedManager(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Listener.OnConnected<C> listener) {
        Object object = this.lock;
        synchronized (object) {
            ConcurrentEntry<Listener.OnConnected<C>> head = REF.get(this);
            if (!this.entries.containsKey(listener)) {
                head = new ConcurrentEntry<Listener.OnConnected<C>>(listener, head);
                this.entries.put(listener, head);
                REF.lazySet(this, head);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Listener.OnConnected<C> listener) {
        Object object = this.lock;
        synchronized (object) {
            ConcurrentEntry concurrentEntry = (ConcurrentEntry)this.entries.get(listener);
            if (concurrentEntry != null) {
                ConcurrentEntry head1 = REF.get(this);
                if (concurrentEntry == head1) {
                    head1 = head1.next();
                } else {
                    concurrentEntry.remove();
                }
                REF.lazySet(this, head1);
                this.entries.remove(listener);
                return true;
            }
            return false;
        }
    }

    public boolean notifyConnected(C connection, AtomicBoolean shutdown) {
        ConcurrentEntry head;
        ConcurrentEntry current = head = REF.get(this);
        while (current != null && !shutdown.get()) {
            Listener.OnConnected listener = (Listener.OnConnected)current.getValue();
            current = current.next();
            try {
                listener.connected(connection);
            }
            catch (Exception e) {
                if (listener instanceof Listener.OnError) {
                    ((Listener.OnError)((Object)listener)).error(connection, e);
                    continue;
                }
                this.logger.error("Unable to notify listener on 'connected' for listener '{}', connection '{}'.", new Object[]{listener, connection, e});
            }
        }
        return head != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.entries.clear();
            this.head = null;
        }
    }
}

