/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.listenerManagement;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.RmiMessages;
import dorkbox.util.ClassHelper;
import dorkbox.util.collections.ConcurrentEntry;
import dorkbox.util.collections.ConcurrentIterator;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;

public final class OnMessageReceivedManager<C extends Connection> {
    private final Logger logger;
    private volatile IdentityMap<Type, ConcurrentIterator> listeners = new IdentityMap(32, 0.8f);
    private static final AtomicReferenceFieldUpdater<OnMessageReceivedManager, IdentityMap> REF = AtomicReferenceFieldUpdater.newUpdater(OnMessageReceivedManager.class, IdentityMap.class, "listeners");
    private final Object lock = new Object();

    public OnMessageReceivedManager(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Listener.OnMessageReceived<C, Object> listener) {
        Class<?> type = listener instanceof Listener.SelfDefinedType ? ((Listener.SelfDefinedType)((Object)listener)).getType() : OnMessageReceivedManager.identifyType(listener);
        Object object = this.lock;
        synchronized (object) {
            IdentityMap listeners = REF.get(this);
            ConcurrentIterator subscribedListeners = (ConcurrentIterator)listeners.get(type);
            if (subscribedListeners == null) {
                subscribedListeners = new ConcurrentIterator();
                listeners.put(type, subscribedListeners);
            }
            subscribedListeners.add(listener);
            REF.lazySet(this, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Listener.OnMessageReceived<C, Object> listener) {
        Class<?> type = listener instanceof Listener.SelfDefinedType ? ((Listener.SelfDefinedType)((Object)listener)).getType() : OnMessageReceivedManager.identifyType(listener);
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            IdentityMap listeners = REF.get(this);
            ConcurrentIterator concurrentIterator = (ConcurrentIterator)listeners.get(type);
            if (concurrentIterator != null) {
                concurrentIterator.remove(listener);
                found = true;
            }
            REF.lazySet(this, listeners);
        }
        return found;
    }

    public boolean notifyReceived(C connection, Object message, AtomicBoolean shutdown) {
        Listener.OnMessageReceived listener;
        ConcurrentEntry current;
        ConcurrentEntry head;
        boolean found = false;
        Class<?> objectType = message.getClass();
        IdentityMap listeners = REF.get(this);
        ConcurrentIterator concurrentIterator = (ConcurrentIterator)listeners.get(objectType);
        if (concurrentIterator != null) {
            current = head = ConcurrentIterator.headREF.get(concurrentIterator);
            while (current != null && !shutdown.get()) {
                listener = (Listener.OnMessageReceived)current.getValue();
                current = current.next();
                try {
                    listener.received(connection, message);
                }
                catch (Exception e) {
                    if (listener instanceof Listener.OnError) {
                        ((Listener.OnError)((Object)listener)).error(connection, e);
                        continue;
                    }
                    this.logger.error("Unable to notify on message '{}' for listener '{}', connection '{}'.", new Object[]{objectType, listener, connection, e});
                }
            }
            boolean bl = found = head != null;
        }
        if (!(message instanceof RmiMessages)) {
            for (objectType = objectType.getSuperclass(); objectType != null; objectType = objectType.getSuperclass()) {
                concurrentIterator = (ConcurrentIterator)listeners.get(objectType);
                if (concurrentIterator == null) continue;
                current = head = ConcurrentIterator.headREF.get(concurrentIterator);
                while (current != null && !shutdown.get()) {
                    listener = (Listener.OnMessageReceived)current.getValue();
                    current = current.next();
                    try {
                        listener.received(connection, message);
                    }
                    catch (Exception e) {
                        if (listener instanceof Listener.OnError) {
                            ((Listener.OnError)((Object)listener)).error(connection, e);
                            continue;
                        }
                        this.logger.error("Unable to notify on message '{}' for listener '{}', connection '{}'.", new Object[]{objectType, listener, connection, e});
                    }
                }
                found = head != null;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.lock;
        synchronized (object) {
            IdentityMap listeners = REF.get(this);
            listeners.clear();
            REF.lazySet(this, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Class<?> classType) {
        boolean found;
        Object object = this.lock;
        synchronized (object) {
            IdentityMap listeners = REF.get(this);
            found = listeners.remove(classType) != null;
            REF.lazySet(this, listeners);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            IdentityMap listeners = REF.get(this);
            IdentityMap.Entries entries = listeners.entries();
            for (IdentityMap.Entry next : entries) {
                if (next.value == null) continue;
                ((ConcurrentIterator)next.value).clear();
            }
            listeners.clear();
            REF.lazySet(this, listeners);
        }
    }

    private static Class<?> identifyType(Object listener) {
        Class<?> clazz = listener.getClass();
        Class<?> objectType = ClassHelper.getGenericParameterAsClassForSuperClass(clazz, 1);
        if (objectType != null) {
            Class<?> objectType2;
            if (objectType != Object.class && ClassHelper.hasInterface(Connection.class, objectType) && (objectType2 = ClassHelper.getGenericParameterAsClassForSuperClass(clazz, 2)) != null) {
                objectType = objectType2;
            }
            return objectType;
        }
        return Object.class;
    }
}

