/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.ping;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.Ping;
import dorkbox.network.connection.PingListener;
import dorkbox.network.connection.ping.PingCanceledException;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.network.connection.ping.PingTuple;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class PingFuture
implements Ping {
    private static final AtomicInteger pingCounter = new AtomicInteger(0);
    private final Promise<PingTuple<? extends Connection>> promise;
    private final int id;
    private final long sentTime;

    PingFuture() {
        this(null);
    }

    public PingFuture(Promise<PingTuple<? extends Connection>> promise) {
        this.promise = promise;
        this.id = pingCounter.getAndIncrement();
        this.sentTime = System.currentTimeMillis();
        if (this.id == Integer.MAX_VALUE) {
            pingCounter.set(0);
        }
    }

    @Override
    public int getResponse() {
        try {
            PingTuple entry = (PingTuple)this.promise.syncUninterruptibly().get();
            if (entry != null) {
                return entry.responseTime;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public <C extends Connection> void add(PingListener<C> listener) {
        this.promise.addListener(listener);
    }

    @Override
    public <C extends Connection> void remove(PingListener<C> listener) {
        this.promise.removeListener(listener);
    }

    @Override
    public void cancel() {
        this.promise.tryFailure((Throwable)new PingCanceledException());
    }

    public <C extends Connection> void setSuccess(C connection, PingMessage ping) {
        if (ping.id == this.id) {
            long longTime = System.currentTimeMillis() - this.sentTime;
            if (longTime < Integer.MAX_VALUE) {
                this.promise.setSuccess(new PingTuple<C>(connection, (int)longTime));
            } else {
                this.promise.setSuccess(new PingTuple<C>(connection, Integer.MAX_VALUE));
            }
        }
    }

    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    public int getId() {
        return this.id;
    }
}

