/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration;

import dorkbox.network.connection.ConnectionImpl;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class MetaChannel {
    private volatile long nanoSecBetweenTCP = 0L;
    public Integer connectionID = null;
    public Channel localChannel = null;
    public Channel tcpChannel = null;
    public Channel udpChannel = null;
    public InetSocketAddress udpRemoteAddress = null;
    public ConnectionImpl connection;
    public ECPublicKeyParameters publicKey;
    public AsymmetricCipherKeyPair ecdhKey;
    public byte[] aesKey;
    public byte[] aesIV;
    public boolean changedRemoteKey = false;

    public void close() {
        if (this.localChannel != null) {
            this.localChannel.close();
        }
        if (this.tcpChannel != null) {
            this.tcpChannel.close();
        }
        if (this.udpChannel != null && this.udpRemoteAddress == null) {
            this.udpChannel.close();
        }
    }

    public void close(long maxShutdownWaitTimeInMilliSeconds) {
        if (this.localChannel != null && this.localChannel.isOpen()) {
            this.localChannel.close();
        }
        if (this.tcpChannel != null && this.tcpChannel.isOpen()) {
            this.tcpChannel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
        }
        if (this.udpChannel != null && this.udpRemoteAddress == null && this.udpChannel.isOpen()) {
            this.udpChannel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
        }
    }

    public void updateTcpRoundTripTime() {
        this.nanoSecBetweenTCP = System.nanoTime() - this.nanoSecBetweenTCP;
    }

    public long getNanoSecBetweenTCP() {
        return this.nanoSecBetweenTCP;
    }
}

