/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class RegistrationHandler<C extends Connection>
extends ChannelInboundHandlerAdapter {
    protected static final String CONNECTION_HANDLER = "connectionHandler";
    protected final RegistrationWrapper<C> registrationWrapper;
    protected final Logger logger;
    protected final String name;

    public RegistrationHandler(String name, RegistrationWrapper<C> registrationWrapper) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)this.name);
        this.registrationWrapper = registrationWrapper;
    }

    protected void initChannel(Channel channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRegistered(ChannelHandlerContext context) throws Exception {
        boolean success = false;
        try {
            this.initChannel(context.channel());
            context.fireChannelRegistered();
            success = true;
        }
        catch (Throwable t) {
            this.logger.error("Failed to initialize a channel. Closing: {}", (Object)context.channel(), (Object)t);
        }
        finally {
            if (!success) {
                context.close();
            }
        }
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        this.logger.error("ChannelActive NOT IMPLEMENTED!");
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        this.logger.error("MessageReceived NOT IMPLEMENTED!");
    }

    public void channelReadComplete(ChannelHandlerContext context) throws Exception {
        context.flush();
    }

    public abstract void exceptionCaught(ChannelHandlerContext var1, Throwable var2) throws Exception;

    public MetaChannel shutdown(RegistrationWrapper<C> registrationWrapper, Channel channel) {
        if (channel.isOpen()) {
            channel.close();
        }
        if (registrationWrapper != null) {
            MetaChannel metaChannel = registrationWrapper.closeChannel(channel, EndPointBase.maxShutdownWaitTimeInMilliSeconds);
            registrationWrapper.abortRegistrationIfClient();
            return metaChannel;
        }
        return null;
    }
}

