/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.local;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.RegistrationHandler;
import dorkbox.network.pipeline.LocalRmiDecoder;
import dorkbox.network.pipeline.LocalRmiEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;

public abstract class RegistrationLocalHandler<C extends Connection>
extends RegistrationHandler<C> {
    protected static final String LOCAL_RMI_ENCODER = "localRmiEncoder";
    protected static final String LOCAL_RMI_DECODER = "localRmiDecoder";
    protected final LocalRmiEncoder encoder = new LocalRmiEncoder();
    protected final LocalRmiDecoder decoder = new LocalRmiDecoder();

    public RegistrationLocalHandler(String name, RegistrationWrapper<C> registrationWrapper) {
        super(name, registrationWrapper);
    }

    @Override
    protected void initChannel(Channel channel) {
        MetaChannel metaChannel = new MetaChannel();
        metaChannel.localChannel = channel;
        this.registrationWrapper.addChannel(channel.hashCode(), metaChannel);
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("New LOCAL connection.");
        }
        this.registrationWrapper.connection0(metaChannel);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        this.logger.error("Unexpected exception while trying to receive data on LOCAL channel.  ({})" + System.getProperty("line.separator"), (Object)channel.remoteAddress(), (Object)cause);
        if (channel.isOpen()) {
            channel.close();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
    }

    public final void channelInactive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        this.logger.info("Closed LOCAL connection: {}", (Object)channel.remoteAddress());
        this.registrationWrapper.closeChannel(channel, EndPointBase.maxShutdownWaitTimeInMilliSeconds);
        super.channelInactive(context);
    }
}

