/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.local;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.local.RegistrationLocalHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;

public class RegistrationLocalHandlerClient<C extends Connection>
extends RegistrationLocalHandler<C> {
    public RegistrationLocalHandlerClient(String name, RegistrationWrapper<C> registrationWrapper) {
        super(name, registrationWrapper);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        Channel channel = context.channel();
        this.logger.info("Connected to LOCAL connection. [{} ==> {}]", (Object)context.channel().localAddress(), (Object)channel.remoteAddress());
        channel.writeAndFlush((Object)new Registration());
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        ReferenceCountUtil.release((Object)message);
        Channel channel = context.channel();
        MetaChannel metaChannel = this.registrationWrapper.removeChannel(channel.hashCode());
        if (metaChannel != null) {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.remove((ChannelHandler)this);
            this.registrationWrapper.registerNextProtocol0();
            ConnectionImpl connection = metaChannel.connection;
            if (this.registrationWrapper.rmiEnabled()) {
                pipeline.addFirst("localRmiEncoder", (ChannelHandler)this.decoder);
                pipeline.addFirst("localRmiDecoder", (ChannelHandler)this.encoder);
            }
            pipeline.addLast("connectionHandler", (ChannelHandler)connection);
            this.registrationWrapper.connectionConnected0(connection);
        } else {
            this.logger.error("Error registering LOCAL channel! MetaChannel is null!");
            this.shutdown(this.registrationWrapper, channel);
        }
    }
}

