/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.local;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.local.RegistrationLocalHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;

public class RegistrationLocalHandlerServer<C extends Connection>
extends RegistrationLocalHandler<C> {
    public RegistrationLocalHandlerServer(String name, RegistrationWrapper<C> registrationWrapper) {
        super(name, registrationWrapper);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        this.logger.info("Connected to LOCAL connection. [{} <== {}]", (Object)context.channel().localAddress(), (Object)channel.remoteAddress());
        super.channelActive(context);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.remove((ChannelHandler)this);
        channel.writeAndFlush(message);
        ReferenceCountUtil.release((Object)message);
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Sent registration");
        }
        ConnectionImpl connection = null;
        MetaChannel metaChannel = this.registrationWrapper.removeChannel(channel.hashCode());
        if (metaChannel != null) {
            connection = metaChannel.connection;
        }
        if (connection != null) {
            if (this.registrationWrapper.rmiEnabled()) {
                pipeline.addFirst("localRmiEncoder", (ChannelHandler)this.decoder);
                pipeline.addFirst("localRmiDecoder", (ChannelHandler)this.encoder);
            }
            pipeline.addLast("connectionHandler", (ChannelHandler)connection);
            this.registrationWrapper.connectionConnected0(connection);
        }
    }
}

