/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.RegistrationHandler;
import dorkbox.network.pipeline.KryoDecoder;
import dorkbox.network.pipeline.KryoDecoderCrypto;
import dorkbox.network.pipeline.udp.KryoDecoderUdpCrypto;
import dorkbox.network.pipeline.udp.KryoEncoderUdpCrypto;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.FastThreadLocal;
import dorkbox.util.crypto.CryptoECC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.slf4j.Logger;

public abstract class RegistrationRemoteHandler<C extends Connection>
extends RegistrationHandler<C> {
    static final String KRYO_ENCODER = "kryoEncoder";
    static final String KRYO_DECODER = "kryoDecoder";
    private static final String IDLE_HANDLER_FULL = "idleHandlerFull";
    private static final String FRAME_AND_KRYO_ENCODER = "frameAndKryoEncoder";
    private static final String FRAME_AND_KRYO_DECODER = "frameAndKryoDecoder";
    private static final String FRAME_AND_KRYO_CRYPTO_ENCODER = "frameAndKryoCryptoEncoder";
    private static final String FRAME_AND_KRYO_CRYPTO_DECODER = "frameAndKryoCryptoDecoder";
    private static final String KRYO_CRYPTO_ENCODER = "kryoCryptoEncoder";
    private static final String KRYO_CRYPTO_DECODER = "kryoCryptoDecoder";
    private static final String IDLE_HANDLER = "idleHandler";
    static final FastThreadLocal<GCMBlockCipher> aesEngine = new FastThreadLocal<GCMBlockCipher>(){

        @Override
        public GCMBlockCipher initialValue() {
            return new GCMBlockCipher((BlockCipher)new AESFastEngine());
        }
    };
    final FastThreadLocal<IESEngine> eccEngineLocal = new FastThreadLocal<IESEngine>(){

        @Override
        public IESEngine initialValue() {
            return CryptoECC.createEngine();
        }
    };
    protected final CryptoSerializationManager serializationManager;

    public static boolean checkEqual(InetAddress serverA, InetAddress serverB) {
        if (serverA == null || serverB == null) {
            return false;
        }
        return Arrays.equals(serverA.getAddress(), serverB.getAddress());
    }

    RegistrationRemoteHandler(String name, RegistrationWrapper<C> registrationWrapper, CryptoSerializationManager serializationManager) {
        super(name, registrationWrapper);
        this.serializationManager = serializationManager;
    }

    @Override
    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst(FRAME_AND_KRYO_DECODER, (ChannelHandler)new KryoDecoder(this.serializationManager));
        int idleTimeout = this.registrationWrapper.getIdleTimeout();
        if (idleTimeout > 0) {
            pipeline.addFirst(IDLE_HANDLER, (ChannelHandler)new IdleStateHandler(4, 0, 0));
        }
        pipeline.addFirst(FRAME_AND_KRYO_ENCODER, (ChannelHandler)this.registrationWrapper.getKryoEncoder());
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        Class<?> channelClass = channel.getClass();
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append("Connected to remote ");
        if (channelClass == NioSocketChannel.class || channelClass == EpollSocketChannel.class) {
            stringBuilder.append("TCP");
        } else if (channelClass == NioDatagramChannel.class || channelClass == EpollDatagramChannel.class) {
            stringBuilder.append("UDP");
        } else {
            stringBuilder.append("UNKNOWN");
        }
        stringBuilder.append(" connection. [");
        stringBuilder.append(channel.localAddress());
        boolean isSessionless = channel instanceof NioDatagramChannel;
        if (isSessionless) {
            if (channel.remoteAddress() != null) {
                stringBuilder.append(" ==> ");
                stringBuilder.append(channel.remoteAddress());
            } else {
                stringBuilder.append(" <== ");
                stringBuilder.append("?????");
            }
        } else {
            stringBuilder.append(this.getConnectionDirection());
            stringBuilder.append(channel.remoteAddress());
        }
        stringBuilder.append("]");
        this.logger.info(stringBuilder.toString());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        this.logger.error("Unexpected exception while trying to send/receive data on Client remote (network) channel.  ({})" + System.getProperty("line.separator"), (Object)channel.remoteAddress(), (Object)cause);
        if (channel.isOpen()) {
            channel.close();
        }
    }

    protected abstract String getConnectionDirection();

    final void setupConnectionCrypto(MetaChannel metaChannel) {
        if (this.logger.isDebugEnabled()) {
            String type = "TCP";
            if (metaChannel.udpChannel != null) {
                type = type + "/UDP";
            }
            InetSocketAddress address = (InetSocketAddress)metaChannel.tcpChannel.remoteAddress();
            this.logger.debug("Encrypting {} session with {}", (Object)type, (Object)address.getAddress());
        }
        ChannelPipeline pipeline = metaChannel.tcpChannel.pipeline();
        int idleTimeout = this.registrationWrapper.getIdleTimeout();
        pipeline.replace(FRAME_AND_KRYO_DECODER, FRAME_AND_KRYO_CRYPTO_DECODER, (ChannelHandler)new KryoDecoderCrypto(this.serializationManager));
        if (idleTimeout > 0) {
            pipeline.replace(IDLE_HANDLER, IDLE_HANDLER_FULL, (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
        }
        pipeline.replace(FRAME_AND_KRYO_ENCODER, FRAME_AND_KRYO_CRYPTO_ENCODER, (ChannelHandler)this.registrationWrapper.getKryoEncoderCrypto());
        if (metaChannel.udpChannel != null && metaChannel.udpRemoteAddress == null) {
            pipeline = metaChannel.udpChannel.pipeline();
            pipeline.replace(KRYO_DECODER, KRYO_CRYPTO_DECODER, (ChannelHandler)new KryoDecoderUdpCrypto(this.serializationManager));
            pipeline.replace(KRYO_ENCODER, KRYO_CRYPTO_ENCODER, (ChannelHandler)new KryoEncoderUdpCrypto(this.serializationManager));
        }
    }

    final void establishConnection(MetaChannel metaChannel) {
        ChannelPipeline tcpPipe = metaChannel.tcpChannel.pipeline();
        ChannelPipeline udpPipe = metaChannel.udpChannel != null && metaChannel.udpRemoteAddress == null ? metaChannel.udpChannel.pipeline() : null;
        ConnectionImpl connection = (ConnectionImpl)this.registrationWrapper.connection0(metaChannel);
        tcpPipe.addLast("connectionHandler", (ChannelHandler)connection);
        if (udpPipe != null) {
            udpPipe.addLast("connectionHandler", (ChannelHandler)connection);
        }
    }

    final boolean verifyAesInfo(Object message, Channel channel, RegistrationWrapper<C> registrationWrapper, MetaChannel metaChannel, Logger logger) {
        if (metaChannel.aesKey.length != 32) {
            logger.error("Fatal error trying to use AES key (wrong key length).");
            this.shutdown(registrationWrapper, channel);
            ReferenceCountUtil.release((Object)message);
            return true;
        }
        if (metaChannel.aesIV.length != 12) {
            logger.error("Fatal error trying to use AES IV (wrong IV length).");
            this.shutdown(registrationWrapper, channel);
            ReferenceCountUtil.release((Object)message);
            return true;
        }
        return false;
    }

    final void setupConnection(MetaChannel metaChannel) {
        boolean registerServer = this.registrationWrapper.setupChannels(this, metaChannel);
        if (registerServer) {
            this.setupServerUdpConnection(metaChannel);
        }
        if (this.logger.isInfoEnabled()) {
            String type = "TCP";
            if (metaChannel.udpChannel != null) {
                type = type + "/UDP";
            }
            InetSocketAddress address = (InetSocketAddress)metaChannel.tcpChannel.remoteAddress();
            this.logger.info("Created a {} connection with {}", (Object)type, (Object)address.getAddress());
        }
    }

    protected void setupServerUdpConnection(MetaChannel metaChannel) {
    }

    final void notifyConnection(MetaChannel metaChannel) {
        this.registrationWrapper.connectionConnected0(metaChannel.connection);
    }

    public final void channelInactive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        this.logger.info("Closed connection: {}", (Object)channel.remoteAddress());
        this.registrationWrapper.closeChannel(channel, EndPointBase.maxShutdownWaitTimeInMilliSeconds);
        super.channelInactive(context);
    }
}

