/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClient;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.bytes.OptimizeUtilsByteArray;
import dorkbox.util.crypto.CryptoAES;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.exceptions.SecurityException;
import dorkbox.util.serialization.EccPublicKeySerializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.slf4j.Logger;

public class RegistrationRemoteHandlerClientTCP<C extends Connection>
extends RegistrationRemoteHandlerClient<C> {
    private static final String DELETE_IP = "eleteIP";
    private static final ECParameterSpec eccSpec = ECNamedCurveTable.getParameterSpec((String)"curve25519");

    public RegistrationRemoteHandlerClientTCP(String name, RegistrationWrapper<C> registrationWrapper, CryptoSerializationManager serializationManager) {
        super(name, registrationWrapper, serializationManager);
        String ipAsString = System.getProperty(DELETE_IP);
        if (ipAsString != null) {
            byte[] address;
            block8: {
                System.setProperty(DELETE_IP, "");
                address = null;
                try {
                    String[] split = ipAsString.split("\\.");
                    if (split.length != 4) break block8;
                    address = new byte[4];
                    for (int i = 0; i < split.length; ++i) {
                        int asInt = Integer.parseInt(split[i]);
                        if (asInt < 0 || asInt > 255) {
                            address = null;
                            break;
                        }
                        address[i] = (byte)Integer.parseInt(split[i]);
                    }
                }
                catch (Exception e) {
                    address = null;
                }
            }
            if (address != null) {
                try {
                    registrationWrapper.removeRegisteredServerKey(address);
                }
                catch (SecurityException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void initChannel(Channel channel) {
        this.logger.trace("Channel registered: {}", (Object)channel.getClass().getSimpleName());
        super.initChannel(channel);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        Channel channel = context.channel();
        MetaChannel metaChannel = new MetaChannel();
        metaChannel.tcpChannel = channel;
        this.registrationWrapper.addChannel(channel.hashCode(), metaChannel);
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Start new TCP Connection. Sending request to server");
        }
        Registration registration = new Registration();
        registration.publicKey = this.registrationWrapper.getPublicKey();
        channel.writeAndFlush((Object)registration);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        RegistrationWrapper registrationWrapper2 = this.registrationWrapper;
        Logger logger2 = this.logger;
        if (message instanceof Registration) {
            MetaChannel metaChannel = registrationWrapper2.getChannel(channel.hashCode());
            if (metaChannel != null) {
                metaChannel.updateTcpRoundTripTime();
                Registration registration = (Registration)message;
                if (metaChannel.connectionID == null) {
                    InetSocketAddress tcpRemoteServer = (InetSocketAddress)channel.remoteAddress();
                    boolean valid = registrationWrapper2.validateRemoteAddress(tcpRemoteServer, registration.publicKey);
                    if (!valid) {
                        String hostAddress = tcpRemoteServer.getAddress().getHostAddress();
                        logger2.error("Invalid ECC public key for server IP {} during handshake. WARNING. The server has changed!", (Object)hostAddress);
                        logger2.error("Fix by adding the argument   -D{} {}   when starting the client.", (Object)DELETE_IP, (Object)hostAddress);
                        metaChannel.changedRemoteKey = true;
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    IESEngine decrypt = (IESEngine)this.eccEngineLocal.get();
                    byte[] aesKeyBytes = CryptoECC.decrypt(decrypt, registrationWrapper2.getPrivateKey(), (CipherParameters)registration.publicKey, registration.eccParameters, registration.aesKey, this.logger);
                    if (aesKeyBytes.length != 32) {
                        logger2.error("Invalid decryption of aesKey. Aborting.");
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    GCMBlockCipher gcmAesEngine = (GCMBlockCipher)aesEngine.get();
                    byte[] payload = CryptoAES.decrypt(gcmAesEngine, aesKeyBytes, registration.aesIV, registration.payload, this.logger);
                    if (payload.length == 0) {
                        logger2.error("Invalid decryption of payload. Aborting.");
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    if (!OptimizeUtilsByteArray.canReadInt(payload)) {
                        logger2.error("Invalid decryption of connection ID. Aborting.");
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    metaChannel.connectionID = OptimizeUtilsByteArray.readInt(payload, true);
                    int intLength = OptimizeUtilsByteArray.intLength(metaChannel.connectionID, true);
                    byte[] ecdhPubKeyBytes = Arrays.copyOfRange(payload, intLength, payload.length);
                    ECPublicKeyParameters ecdhPubKey = EccPublicKeySerializer.read(new Input(ecdhPubKeyBytes));
                    if (ecdhPubKey == null) {
                        logger2.error("Invalid decode of ecdh public key. Aborting.");
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    metaChannel.ecdhKey = CryptoECC.generateKeyPair(eccSpec, new SecureRandom());
                    registrationWrapper2.addChannel(metaChannel.connectionID, metaChannel);
                    metaChannel.publicKey = registration.publicKey;
                    ECDHCBasicAgreement agreement = new ECDHCBasicAgreement();
                    agreement.init((CipherParameters)metaChannel.ecdhKey.getPrivate());
                    BigInteger shared = agreement.calculateAgreement((CipherParameters)ecdhPubKey);
                    byte[] keySeed = shared.toByteArray();
                    SHA384Digest sha384 = new SHA384Digest();
                    byte[] digest = new byte[sha384.getDigestSize()];
                    sha384.update(keySeed, 0, keySeed.length);
                    sha384.doFinal(digest, 0);
                    metaChannel.aesKey = Arrays.copyOfRange(digest, 0, 32);
                    metaChannel.aesIV = Arrays.copyOfRange(digest, 32, 44);
                    if (this.verifyAesInfo(message, channel, registrationWrapper2, metaChannel, logger2)) {
                        return;
                    }
                    Registration register = new Registration();
                    Output output = new Output(1024);
                    EccPublicKeySerializer.write(output, (ECPublicKeyParameters)metaChannel.ecdhKey.getPublic());
                    byte[] pubKeyAsBytes = output.toBytes();
                    register.payload = CryptoAES.encrypt(gcmAesEngine, aesKeyBytes, registration.aesIV, pubKeyAsBytes, this.logger);
                    channel.writeAndFlush((Object)register);
                    ReferenceCountUtil.release((Object)message);
                    return;
                }
                if (metaChannel.connection == null) {
                    if (metaChannel.ecdhKey != null) {
                        metaChannel.ecdhKey = null;
                        boolean isDoneWithRegistration = registrationWrapper2.registerNextProtocol0();
                        if (isDoneWithRegistration) {
                            channel.writeAndFlush((Object)registration);
                            metaChannel.updateTcpRoundTripTime();
                        }
                    } else {
                        this.setupConnectionCrypto(metaChannel);
                        this.establishConnection(metaChannel);
                        this.setupConnection(metaChannel);
                        final MetaChannel metaChannel2 = metaChannel;
                        channel.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                Logger logger2 = RegistrationRemoteHandlerClientTCP.this.logger;
                                if (logger2.isTraceEnabled()) {
                                    logger2.trace("Notify Connection");
                                }
                                RegistrationRemoteHandlerClientTCP.this.notifyConnection(metaChannel2);
                            }
                        }, metaChannel.getNanoSecBetweenTCP() * 2L, TimeUnit.NANOSECONDS);
                    }
                }
            }
        } else {
            logger2.error("Error registering TCP with remote server!");
            this.shutdown(registrationWrapper2, channel);
        }
        ReferenceCountUtil.release((Object)message);
    }
}

