/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClient;
import dorkbox.network.pipeline.udp.KryoDecoderUdp;
import dorkbox.network.pipeline.udp.KryoEncoderUdp;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.bytes.OptimizeUtilsByteArray;
import dorkbox.util.crypto.CryptoAES;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.slf4j.Logger;

public class RegistrationRemoteHandlerClientUDP<C extends Connection>
extends RegistrationRemoteHandlerClient<C> {
    public RegistrationRemoteHandlerClientUDP(String name, RegistrationWrapper<C> registrationWrapper, CryptoSerializationManager serializationManager) {
        super(name, registrationWrapper, serializationManager);
    }

    @Override
    protected void initChannel(Channel channel) {
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Channel registered: " + channel.getClass().getSimpleName());
        }
        channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(EndPointBase.udpMaxSize));
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("kryoDecoder", (ChannelHandler)new KryoDecoderUdp(this.serializationManager));
        pipeline.addFirst("kryoEncoder", (ChannelHandler)new KryoEncoderUdp(this.serializationManager));
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        Channel channel = context.channel();
        InetSocketAddress udpRemoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (udpRemoteAddress != null) {
            InetAddress udpRemoteServer = udpRemoteAddress.getAddress();
            boolean success = this.registrationWrapper.associateChannels(channel, udpRemoteServer);
            if (!success) {
                throw new IOException("UDP cannot connect to a remote server before TCP is established!");
            }
            Logger logger2 = this.logger;
            if (logger2.isTraceEnabled()) {
                logger2.trace("Start new UDP Connection. Sending request to server");
            }
        } else {
            throw new IOException("UDP cannot connect to remote server! No remote address specified!");
        }
        Registration registration = new Registration();
        channel.writeAndFlush((Object)registration);
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        RegistrationWrapper registrationWrapper2 = this.registrationWrapper;
        Channel channel = context.channel();
        MetaChannel metaChannel = registrationWrapper2.getChannel(channel.hashCode());
        if (metaChannel != null && message instanceof Registration) {
            Registration registration = (Registration)message;
            byte[] payload = CryptoAES.decrypt((GCMBlockCipher)aesEngine.get(), metaChannel.aesKey, metaChannel.aesIV, registration.payload, this.logger);
            if (!OptimizeUtilsByteArray.canReadInt(payload)) {
                this.logger.error("Invalid decryption of connection ID. Aborting.");
                this.shutdown(registrationWrapper2, channel);
                return;
            }
            Integer connectionID = OptimizeUtilsByteArray.readInt(payload, true);
            MetaChannel metaChannel2 = registrationWrapper2.getChannel(connectionID);
            if (metaChannel2 != null) {
                boolean isDoneWithRegistration = registrationWrapper2.registerNextProtocol0();
                if (isDoneWithRegistration) {
                    metaChannel.tcpChannel.writeAndFlush((Object)registration);
                    metaChannel.updateTcpRoundTripTime();
                }
                channel.pipeline().remove((ChannelHandler)this);
                return;
            }
        }
        this.logger.error("Error registering UDP with remote server!");
        this.shutdown(registrationWrapper2, channel);
    }
}

