/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServer;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.bytes.OptimizeUtilsByteArray;
import dorkbox.util.crypto.CryptoAES;
import dorkbox.util.crypto.CryptoECC;
import dorkbox.util.serialization.EccPublicKeySerializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class RegistrationRemoteHandlerServerTCP<C extends Connection>
extends RegistrationRemoteHandlerServer<C> {
    private static final long ECDH_TIMEOUT = 36000000000000L;
    private static final ECParameterSpec eccSpec = ECNamedCurveTable.getParameterSpec((String)"curve25519");
    private final Object ecdhKeyLock = new Object();
    private AsymmetricCipherKeyPair ecdhKeyPair;
    private volatile long ecdhTimeout = System.nanoTime();

    public RegistrationRemoteHandlerServerTCP(String name, RegistrationWrapper<C> registrationWrapper, CryptoSerializationManager serializationManager) {
        super(name, registrationWrapper, serializationManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsymmetricCipherKeyPair getEchdKeyOnRotate(SecureRandom secureRandom) {
        if (this.ecdhKeyPair == null || System.nanoTime() - this.ecdhTimeout > 36000000000000L) {
            Object object = this.ecdhKeyLock;
            synchronized (object) {
                this.ecdhTimeout = System.nanoTime();
                this.ecdhKeyPair = CryptoECC.generateKeyPair(eccSpec, secureRandom);
            }
        }
        return this.ecdhKeyPair;
    }

    @Override
    protected void initChannel(Channel channel) {
        super.initChannel(channel);
    }

    @Override
    public void channelActive(ChannelHandlerContext context) throws Exception {
        super.channelActive(context);
        Channel channel = context.channel();
        MetaChannel metaChannel = new MetaChannel();
        metaChannel.tcpChannel = channel;
        this.registrationWrapper.addChannel(channel.hashCode(), metaChannel);
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace(this.name, (Object)"New TCP connection. Saving TCP channel info.");
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        RegistrationWrapper registrationWrapper2 = this.registrationWrapper;
        if (message instanceof Registration) {
            Registration registration = (Registration)message;
            MetaChannel metaChannel = registrationWrapper2.getChannel(channel.hashCode());
            Logger logger2 = this.logger;
            if (metaChannel != null) {
                metaChannel.updateTcpRoundTripTime();
                SecureRandom secureRandom = registrationWrapper2.getSecureRandom();
                GCMBlockCipher gcmAesEngine = (GCMBlockCipher)aesEngine.get();
                if (metaChannel.connectionID == null) {
                    if (registration.publicKey == null) {
                        logger2.error("Null ECC public key during client handshake. This shouldn't happen!");
                        this.shutdown(registrationWrapper2, channel);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    InetSocketAddress tcpRemoteClient = (InetSocketAddress)channel.remoteAddress();
                    boolean valid = registrationWrapper2.validateRemoteAddress(tcpRemoteClient, registration.publicKey);
                    if (!valid) {
                        if (logger2.isInfoEnabled()) {
                            logger2.info("Invalid ECC public key for IP {} during handshake with client. Toggling extra flag in channel to indicate this.", (Object)tcpRemoteClient.getAddress().getHostAddress());
                        }
                        metaChannel.changedRemoteKey = true;
                    }
                    Integer connectionID = registrationWrapper2.initializeChannel(metaChannel);
                    Registration register = new Registration();
                    metaChannel.publicKey = registration.publicKey;
                    metaChannel.ecdhKey = this.getEchdKeyOnRotate(secureRandom);
                    Output output = new Output(1024);
                    EccPublicKeySerializer.write(output, (ECPublicKeyParameters)metaChannel.ecdhKey.getPublic());
                    byte[] pubKeyAsBytes = output.toBytes();
                    int intLength = OptimizeUtilsByteArray.intLength(connectionID, true);
                    byte[] idAsBytes = new byte[intLength];
                    OptimizeUtilsByteArray.writeInt(idAsBytes, connectionID, true);
                    byte[] combinedBytes = Arrays.concatenate((byte[])idAsBytes, (byte[])pubKeyAsBytes);
                    metaChannel.aesKey = new byte[32];
                    metaChannel.aesIV = new byte[12];
                    secureRandom.nextBytes(metaChannel.aesKey);
                    secureRandom.nextBytes(metaChannel.aesIV);
                    IESEngine encrypt = (IESEngine)this.eccEngineLocal.get();
                    register.publicKey = registrationWrapper2.getPublicKey();
                    register.eccParameters = CryptoECC.generateSharedParameters(secureRandom);
                    register.eccParameters = CryptoECC.generateSharedParameters(secureRandom);
                    register.aesIV = metaChannel.aesIV;
                    register.aesKey = CryptoECC.encrypt(encrypt, registrationWrapper2.getPrivateKey(), (CipherParameters)metaChannel.publicKey, register.eccParameters, metaChannel.aesKey, this.logger);
                    register.payload = CryptoAES.encrypt(gcmAesEngine, metaChannel.aesKey, register.aesIV, combinedBytes, this.logger);
                    channel.writeAndFlush((Object)register);
                    if (logger2.isTraceEnabled()) {
                        logger2.trace("Assigning new random connection ID for TCP and performing ECDH.");
                    }
                    metaChannel.updateTcpRoundTripTime();
                    ReferenceCountUtil.release((Object)message);
                    return;
                }
                if (metaChannel.connection == null) {
                    if (metaChannel.ecdhKey != null) {
                        byte[] payload = CryptoAES.decrypt(gcmAesEngine, metaChannel.aesKey, metaChannel.aesIV, registration.payload, this.logger);
                        if (payload.length == 0) {
                            logger2.error("Invalid decryption of payload. Aborting.");
                            this.shutdown(registrationWrapper2, channel);
                            ReferenceCountUtil.release((Object)message);
                            return;
                        }
                        ECPublicKeyParameters ecdhPubKey = EccPublicKeySerializer.read(new Input(payload));
                        if (ecdhPubKey == null) {
                            logger2.error("Invalid decode of ecdh public key. Aborting.");
                            this.shutdown(registrationWrapper2, channel);
                            ReferenceCountUtil.release((Object)message);
                            return;
                        }
                        ECDHCBasicAgreement agreement = new ECDHCBasicAgreement();
                        agreement.init((CipherParameters)metaChannel.ecdhKey.getPrivate());
                        BigInteger shared = agreement.calculateAgreement((CipherParameters)ecdhPubKey);
                        metaChannel.aesKey = null;
                        metaChannel.aesIV = null;
                        metaChannel.ecdhKey = null;
                        byte[] keySeed = shared.toByteArray();
                        SHA384Digest sha384 = new SHA384Digest();
                        byte[] digest = new byte[sha384.getDigestSize()];
                        sha384.update(keySeed, 0, keySeed.length);
                        sha384.doFinal(digest, 0);
                        metaChannel.aesKey = Arrays.copyOfRange((byte[])digest, (int)0, (int)32);
                        metaChannel.aesIV = Arrays.copyOfRange((byte[])digest, (int)32, (int)44);
                        if (this.verifyAesInfo(message, channel, registrationWrapper2, metaChannel, logger2)) {
                            return;
                        }
                        channel.writeAndFlush((Object)new Registration());
                    } else {
                        channel.writeAndFlush((Object)registration);
                        this.setupConnectionCrypto(metaChannel);
                        this.establishConnection(metaChannel);
                        this.setupConnection(metaChannel);
                        final MetaChannel chan2 = metaChannel;
                        channel.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                Logger logger2 = RegistrationRemoteHandlerServerTCP.this.logger;
                                if (logger2.isTraceEnabled()) {
                                    logger2.trace("Notify Connection");
                                }
                                RegistrationRemoteHandlerServerTCP.this.notifyConnection(chan2);
                            }
                        }, metaChannel.getNanoSecBetweenTCP() * 2L, TimeUnit.NANOSECONDS);
                    }
                }
                ReferenceCountUtil.release((Object)message);
                return;
            }
            logger2.error("Error registering TCP channel! MetaChannel is null!");
        }
        this.shutdown(registrationWrapper2, channel);
        ReferenceCountUtil.release((Object)message);
    }
}

