/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.registration.remote;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.CryptoSerializationManager;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.RegistrationWrapper;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandler;
import dorkbox.network.connection.wrapper.UdpWrapper;
import dorkbox.util.bytes.OptimizeUtilsByteArray;
import dorkbox.util.crypto.CryptoAES;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RegistrationRemoteHandlerServerUDP<C extends Connection>
extends MessageToMessageCodec<DatagramPacket, UdpWrapper> {
    private final Logger logger;
    private final ByteBuf discoverResponseBuffer;
    private final RegistrationWrapper<C> registrationWrapper;
    private final dorkbox.network.util.CryptoSerializationManager serializationManager;

    public RegistrationRemoteHandlerServerUDP(String name, RegistrationWrapper<C> registrationWrapper, dorkbox.network.util.CryptoSerializationManager serializationManager) {
        String name1 = name + " Registration-UDP-Server";
        this.logger = LoggerFactory.getLogger((String)name1);
        this.registrationWrapper = registrationWrapper;
        this.serializationManager = serializationManager;
        this.discoverResponseBuffer = Unpooled.buffer((int)1);
        this.discoverResponseBuffer.writeByte(57);
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        context.channel().config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(EndPointBase.udpMaxSize));
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        this.logger.error("Exception caught in UDP stream.", cause);
        super.exceptionCaught(context, cause);
    }

    protected void encode(ChannelHandlerContext context, UdpWrapper msg, List<Object> out) throws Exception {
        Object object = msg.object();
        InetSocketAddress remoteAddress = msg.remoteAddress();
        if (object instanceof ByteBuf) {
            out.add(new DatagramPacket((ByteBuf)object, remoteAddress));
        } else {
            ByteBuf buffer = context.alloc().buffer();
            try {
                ConnectionImpl networkConnection = this.registrationWrapper.getServerUDP(remoteAddress);
                if (networkConnection != null) {
                    this.serializationManager.writeWithCrypto(networkConnection, buffer, object);
                } else {
                    this.serializationManager.write(buffer, object);
                }
                if (buffer != null) {
                    out.add(new DatagramPacket(buffer, remoteAddress));
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to write data to the socket.", (Throwable)e);
                throw e;
            }
        }
    }

    protected void decode(ChannelHandlerContext context, DatagramPacket msg, List<Object> out) throws Exception {
        Channel channel = context.channel();
        ByteBuf data = (ByteBuf)msg.content();
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        Logger logger2 = this.logger;
        if (remoteAddress == null) {
            if (logger2.isDebugEnabled()) {
                logger2.debug("Ignoring packet with null UDP remote address. (Is it broadcast?)");
            }
            return;
        }
        if (data.readableBytes() == 1) {
            if (data.readByte() == 42) {
                channel.writeAndFlush((Object)new UdpWrapper(this.discoverResponseBuffer, remoteAddress));
                if (logger2.isDebugEnabled()) {
                    logger2.debug("Responded to host discovery from: {}", (Object)remoteAddress);
                }
            } else {
                logger2.error("Invalid signature for 'Discover Host' from remote address: {}", (Object)remoteAddress);
            }
        } else {
            this.receivedUDP(context, channel, data, remoteAddress);
        }
    }

    private void receivedUDP(ChannelHandlerContext context, Channel channel, ByteBuf message, InetSocketAddress udpRemoteAddress) throws Exception {
        Logger logger2 = this.logger;
        RegistrationWrapper<C> registrationWrapper2 = this.registrationWrapper;
        dorkbox.network.util.CryptoSerializationManager serializationManager2 = this.serializationManager;
        if (CryptoSerializationManager.isEncrypted(message)) {
            ConnectionImpl connection = registrationWrapper2.getServerUDP(udpRemoteAddress);
            if (connection != null) {
                Object object;
                try {
                    object = serializationManager2.readWithCrypto(connection, message, message.writerIndex());
                }
                catch (Exception e) {
                    logger2.error("UDP unable to deserialize buffer", (Throwable)e);
                    this.shutdown(registrationWrapper2, channel);
                    throw e;
                }
                connection.channelRead(object);
            }
        } else {
            Object object;
            try {
                object = serializationManager2.read(message, message.writerIndex());
            }
            catch (Exception e) {
                logger2.error("UDP unable to deserialize buffer", (Throwable)e);
                this.shutdown(registrationWrapper2, channel);
                return;
            }
            if (object instanceof Registration) {
                InetAddress udpRemoteServer = udpRemoteAddress.getAddress();
                MetaChannel metaChannel = registrationWrapper2.getAssociatedChannel_UDP(udpRemoteServer);
                if (metaChannel != null) {
                    metaChannel.udpChannel = channel;
                    metaChannel.udpRemoteAddress = udpRemoteAddress;
                    Registration register = new Registration();
                    int intLength = OptimizeUtilsByteArray.intLength(metaChannel.connectionID, true);
                    byte[] idAsBytes = new byte[intLength];
                    OptimizeUtilsByteArray.writeInt(idAsBytes, metaChannel.connectionID, true);
                    register.payload = CryptoAES.encrypt(RegistrationRemoteHandler.aesEngine.get(), metaChannel.aesKey, metaChannel.aesIV, idAsBytes, this.logger);
                    channel.writeAndFlush((Object)new UdpWrapper(register, udpRemoteAddress));
                    if (logger2.isTraceEnabled()) {
                        logger2.trace("Register UDP connection from {}", (Object)udpRemoteAddress);
                    }
                } else {
                    logger2.error("Error trying to register UDP with incorrect udp specified! UDP: {}", (Object)udpRemoteAddress);
                    this.shutdown(registrationWrapper2, channel);
                }
            } else {
                logger2.error("UDP attempting to spoof client! Unencrypted packet other than registration received.");
                this.shutdown(null, channel);
            }
        }
    }

    public MetaChannel shutdown(RegistrationWrapper<C> registrationWrapper, Channel channel) {
        this.logger.error("SHUTDOWN HANDLER REACHED! SOMETHING MESSED UP! TRYING TO ABORT");
        if (channel.isOpen()) {
            channel.close();
        }
        if (registrationWrapper != null) {
            return registrationWrapper.closeChannel(channel, EndPointBase.maxShutdownWaitTimeInMilliSeconds);
        }
        return null;
    }
}

