/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionPointWriter;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.local.LocalAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ChannelLocalWrapper<C extends Connection>
implements ChannelWrapper<C>,
ConnectionPointWriter {
    private final Channel channel;
    private final AtomicBoolean shouldFlush = new AtomicBoolean(false);
    private String remoteAddress;

    public ChannelLocalWrapper(MetaChannel metaChannel) {
        this.channel = metaChannel.localChannel;
    }

    @Override
    public void write(Object object) {
        this.channel.write(object);
        this.shouldFlush.set(true);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public ConnectionPointWriter tcp() {
        return this;
    }

    @Override
    public ConnectionPointWriter udp() {
        return this;
    }

    @Override
    public final void init() {
        this.remoteAddress = ((LocalAddress)this.channel.remoteAddress()).id();
    }

    @Override
    public void flush() {
        if (this.shouldFlush.compareAndSet(true, false)) {
            this.channel.flush();
        }
    }

    @Override
    public EventLoop getEventLoop() {
        return this.channel.eventLoop();
    }

    @Override
    public ParametersWithIV cryptoParameters() {
        return null;
    }

    @Override
    public boolean isLoopback() {
        return true;
    }

    @Override
    public final String getRemoteHost() {
        return this.remoteAddress;
    }

    @Override
    public void close(Connection connection, ISessionManager<C> sessionManager) {
        long maxShutdownWaitTimeInMilliSeconds = EndPointBase.maxShutdownWaitTimeInMilliSeconds;
        this.shouldFlush.set(false);
        this.channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
    }

    @Override
    public int id() {
        return this.channel.hashCode();
    }

    public int hashCode() {
        return this.channel.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelLocalWrapper other = (ChannelLocalWrapper)obj;
        return !(this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress));
    }
}

