/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.ConnectionPointWriter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChannelNetwork
implements ConnectionPointWriter {
    private final Channel channel;
    private final AtomicBoolean shouldFlush = new AtomicBoolean(false);
    private final ChannelPromise voidPromise;

    public ChannelNetwork(Channel channel) {
        this.channel = channel;
        this.voidPromise = channel.voidPromise();
    }

    @Override
    public void write(Object object) {
        this.channel.write(object, this.voidPromise);
        this.shouldFlush.set(true);
    }

    @Override
    public boolean isWritable() {
        return this.channel.isWritable();
    }

    @Override
    public void flush() {
        if (this.shouldFlush.compareAndSet(true, false)) {
            this.channel.flush();
        }
    }

    public void close(long maxShutdownWaitTimeInMilliSeconds) {
        this.shouldFlush.set(false);
        this.channel.close().awaitUninterruptibly(maxShutdownWaitTimeInMilliSeconds);
    }

    public int id() {
        return this.channel.hashCode();
    }
}

