/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection.wrapper;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionPointWriter;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.UdpServer;
import dorkbox.network.connection.registration.MetaChannel;
import dorkbox.network.connection.wrapper.ChannelNetwork;
import dorkbox.network.connection.wrapper.ChannelNetworkUdp;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.util.FastThreadLocal;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ChannelNetworkWrapper<C extends Connection>
implements ChannelWrapper<C> {
    private final ChannelNetwork tcp;
    private final ChannelNetwork udp;
    private final boolean remotePublicKeyChanged;
    private final String remoteAddress;
    private final boolean isLoopback;
    private final EventLoop eventLoop;
    private final byte[] aesKey;
    private final byte[] aesIV;
    private final FastThreadLocal<ParametersWithIV> cryptoParameters;

    public ChannelNetworkWrapper(MetaChannel metaChannel, UdpServer udpServer) {
        Channel tcpChannel = metaChannel.tcpChannel;
        this.eventLoop = tcpChannel.eventLoop();
        this.isLoopback = ((InetSocketAddress)tcpChannel.remoteAddress()).getAddress().equals(NetUtil.LOCALHOST);
        this.tcp = new ChannelNetwork(tcpChannel);
        this.udp = metaChannel.udpChannel != null ? (metaChannel.udpRemoteAddress != null ? new ChannelNetworkUdp(metaChannel.udpChannel, metaChannel.udpRemoteAddress, udpServer) : new ChannelNetwork(metaChannel.udpChannel)) : null;
        this.remoteAddress = ((InetSocketAddress)tcpChannel.remoteAddress()).getAddress().getHostAddress();
        this.remotePublicKeyChanged = metaChannel.changedRemoteKey;
        this.aesKey = metaChannel.aesKey;
        this.aesIV = metaChannel.aesIV;
        this.cryptoParameters = new FastThreadLocal<ParametersWithIV>(){

            @Override
            public ParametersWithIV initialValue() {
                return new ParametersWithIV((CipherParameters)new KeyParameter(ChannelNetworkWrapper.this.aesKey), ChannelNetworkWrapper.this.aesIV);
            }
        };
    }

    public final boolean remoteKeyChanged() {
        return this.remotePublicKeyChanged;
    }

    @Override
    public ConnectionPointWriter tcp() {
        return this.tcp;
    }

    @Override
    public ConnectionPointWriter udp() {
        return this.udp;
    }

    @Override
    public final void init() {
    }

    @Override
    public void flush() {
        this.tcp.flush();
        if (this.udp != null) {
            this.udp.flush();
        }
    }

    @Override
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    @Override
    public ParametersWithIV cryptoParameters() {
        return this.cryptoParameters.get();
    }

    @Override
    public boolean isLoopback() {
        return this.isLoopback;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteAddress;
    }

    @Override
    public void close(Connection connection, ISessionManager<C> sessionManager) {
        long maxShutdownWaitTimeInMilliSeconds = EndPointBase.maxShutdownWaitTimeInMilliSeconds;
        this.tcp.close(maxShutdownWaitTimeInMilliSeconds);
        if (this.udp != null) {
            this.udp.close(maxShutdownWaitTimeInMilliSeconds);
        }
        Thread.yield();
    }

    @Override
    public int id() {
        return this.tcp.id();
    }

    public int hashCode() {
        return this.remoteAddress.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelNetworkWrapper other = (ChannelNetworkWrapper)obj;
        return !(this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress));
    }

    @Override
    public String toString() {
        return "NetworkConnection [" + this.getRemoteHost() + "]";
    }
}

