/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsResponse;
import dorkbox.network.dns.exceptions.WireParseException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsResponseDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        if (buf.readableBytes() < 12) {
            throw new WireParseException("invalid DNS header - too short");
        }
        DnsInput dnsInput = new DnsInput(buf);
        DnsResponse dnsMessage = new DnsResponse((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), dnsInput);
        out.add(dnsMessage);
    }
}

