/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class DnsOutput {
    private ByteBuf byteBuf;
    private boolean marked = false;

    public DnsOutput() {
        this(32);
    }

    public DnsOutput(int size) {
        this(Unpooled.buffer((int)size));
    }

    public DnsOutput(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public int current() {
        return this.byteBuf.writerIndex();
    }

    public void jump(int index) {
        if (index >= this.byteBuf.writerIndex()) {
            throw new IllegalArgumentException("Unable to jump to invalid position " + index + ". Max is " + this.byteBuf.writerIndex());
        }
        this.byteBuf.writerIndex(index);
    }

    public void save() {
        this.marked = true;
        this.byteBuf.markWriterIndex();
    }

    public void restore() {
        if (!this.marked) {
            throw new IllegalStateException("Not marked first");
        }
        this.byteBuf.resetWriterIndex();
        this.marked = false;
    }

    public void writeU8(int val) {
        this.check(val, 8);
        this.byteBuf.ensureWritable(1);
        this.byteBuf.writeByte(val);
    }

    private void check(long val, int bits) {
        long max = 1L;
        if (val < 0L || val > (max <<= bits)) {
            throw new IllegalArgumentException(val + " out of range for " + bits + " bit value");
        }
    }

    public void writeU16(int val) {
        this.check(val, 16);
        this.byteBuf.ensureWritable(2);
        this.byteBuf.writeShort(val);
    }

    public void writeU16At(int val, int where) {
        this.check(val, 16);
        int saved = this.byteBuf.writerIndex();
        int readSaved = this.byteBuf.readerIndex();
        this.byteBuf.setIndex(where, where);
        this.byteBuf.ensureWritable(2);
        this.byteBuf.writeShort(val);
        this.byteBuf.writerIndex(saved);
        this.byteBuf.readerIndex(readSaved);
    }

    public void writeU32(long val) {
        this.check(val, 32);
        this.byteBuf.ensureWritable(4);
        this.byteBuf.writeInt((int)val);
    }

    public void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b.length);
    }

    public void writeByteArray(byte[] b, int off, int len) {
        this.byteBuf.ensureWritable(len);
        this.byteBuf.writeBytes(b, off, len);
    }

    public void writeCountedString(byte[] s) {
        if (s.length > 255) {
            throw new IllegalArgumentException("Invalid counted string");
        }
        this.byteBuf.ensureWritable(1 + s.length);
        this.byteBuf.writeByte(s.length);
        this.byteBuf.writeBytes(s, 0, s.length);
    }

    public byte[] toByteArray() {
        byte[] out = new byte[this.byteBuf.writerIndex()];
        this.byteBuf.readBytes(out, 0, out.length);
        return out;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }
}

