/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import io.netty.channel.AddressedEnvelope;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.util.Locale;

public class DnsQuestion
extends DnsMessage
implements AddressedEnvelope<DnsQuestion, InetSocketAddress> {
    private InetSocketAddress recipient;
    private final boolean isResolveQuestion;

    private DnsQuestion(boolean isResolveQuestion) {
        this.isResolveQuestion = isResolveQuestion;
        this.recipient = null;
    }

    public boolean isResolveQuestion() {
        return this.isResolveQuestion;
    }

    public static DnsQuestion newResolveQuestion(String inetHost, int type, boolean isRecursionDesired) {
        return DnsQuestion.newQuestion(inetHost, type, isRecursionDesired, true);
    }

    public static DnsQuestion newQuery(String inetHost, int type, boolean isRecursionDesired) {
        return DnsQuestion.newQuestion(inetHost, type, isRecursionDesired, false);
    }

    private static DnsQuestion newQuestion(String inetHost, int type, boolean isRecursionDesired, boolean isResolveQuestion) {
        Name name;
        String hostName = DnsQuestion.hostNameAsciiFix((String)ObjectUtil.checkNotNull((Object)inetHost, (String)"hostname"));
        hostName = hostName.toLowerCase(Locale.US);
        hostName = DnsRecordType.ensureFQDN(type, hostName);
        try {
            name = Name.fromString(hostName);
        }
        catch (Exception e) {
            return null;
        }
        try {
            DnsRecord questionRecord = DnsRecord.newRecord(name, type, 1);
            DnsQuestion question = new DnsQuestion(isResolveQuestion);
            question.getHeader().setOpcode(0);
            if (isRecursionDesired) {
                question.getHeader().setFlag(7);
            }
            question.addRecord(questionRecord, 0);
            question.retain();
            return question;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hostNameAsciiFix(String inetHost) {
        try {
            String hostName = IDN.toASCII(inetHost);
            if (StringUtil.endsWith((CharSequence)inetHost, (char)'.') && !StringUtil.endsWith((CharSequence)hostName, (char)'.')) {
                return hostName + '.';
            }
            return hostName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void init(int id, InetSocketAddress recipient) {
        this.getHeader().setID(id);
        this.recipient = recipient;
    }

    public DnsQuestion content() {
        return this;
    }

    public InetSocketAddress sender() {
        return null;
    }

    public InetSocketAddress recipient() {
        return this.recipient;
    }

    public DnsQuestion touch() {
        return (DnsQuestion)super.touch();
    }

    @Override
    public DnsQuestion touch(Object hint) {
        return (DnsQuestion)super.touch(hint);
    }

    public DnsQuestion retain() {
        return (DnsQuestion)super.retain();
    }

    public DnsQuestion retain(int increment) {
        return (DnsQuestion)super.retain(increment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AddressedEnvelope)) {
            return false;
        }
        AddressedEnvelope that = (AddressedEnvelope)obj;
        if (this.sender() == null ? that.sender() != null : !this.sender().equals(that.sender())) {
            return false;
        }
        return !(this.recipient() == null ? that.recipient() != null : !this.recipient().equals(that.recipient()));
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.sender() != null) {
            hashCode = hashCode * 31 + this.sender().hashCode();
        }
        if (this.recipient() != null) {
            hashCode = hashCode * 31 + this.recipient().hashCode();
        }
        return hashCode;
    }
}

