/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.records.DnsMessage;
import io.netty.channel.AddressedEnvelope;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DnsResponse
extends DnsMessage
implements AddressedEnvelope<DnsResponse, InetSocketAddress> {
    private final InetSocketAddress sender;
    private final InetSocketAddress recipient;

    public DnsResponse(InetSocketAddress sender, InetSocketAddress recipient, DnsInput dnsInput) throws IOException {
        super(dnsInput);
        if (recipient == null && sender == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.sender = sender;
        this.recipient = recipient;
    }

    public DnsResponse content() {
        return this;
    }

    public InetSocketAddress sender() {
        return this.sender;
    }

    public InetSocketAddress recipient() {
        return this.recipient;
    }

    public DnsResponse touch() {
        return (DnsResponse)super.touch();
    }

    @Override
    public DnsResponse touch(Object hint) {
        return (DnsResponse)super.touch(hint);
    }

    public DnsResponse retain() {
        return (DnsResponse)super.retain();
    }

    public DnsResponse retain(int increment) {
        return (DnsResponse)super.retain(increment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AddressedEnvelope)) {
            return false;
        }
        AddressedEnvelope that = (AddressedEnvelope)obj;
        if (this.sender() == null ? that.sender() != null : !this.sender().equals(that.sender())) {
            return false;
        }
        return !(this.recipient() == null ? that.recipient() != null : !this.recipient().equals(that.recipient()));
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.sender() != null) {
            hashCode = hashCode * 31 + this.sender().hashCode();
        }
        if (this.recipient() != null) {
            hashCode = hashCode * 31 + this.recipient().hashCode();
        }
        return hashCode;
    }
}

