/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns;

import java.util.HashMap;

public class Mnemonic {
    private static Integer[] cachedInts = new Integer[64];
    public static final int CASE_SENSITIVE = 1;
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 3;
    private HashMap<String, Integer> strings;
    private HashMap<Integer, String> values;
    private String description;
    private int wordcase;
    private String prefix;
    private int max;
    private boolean numericok;

    public Mnemonic(String description, int wordcase) {
        this.description = description;
        this.wordcase = wordcase;
        this.strings = new HashMap();
        this.values = new HashMap();
        this.max = Integer.MAX_VALUE;
    }

    public void setMaximum(int max) {
        this.max = max;
    }

    public void setPrefix(String prefix) {
        this.prefix = this.sanitize(prefix);
    }

    private String sanitize(String str) {
        if (this.wordcase == 2) {
            return str.toUpperCase();
        }
        if (this.wordcase == 3) {
            return str.toLowerCase();
        }
        return str;
    }

    public void setNumericAllowed(boolean numeric) {
        this.numericok = numeric;
    }

    public void add(int val, String string) {
        this.check(val);
        Integer value = Mnemonic.toInteger(val);
        string = this.sanitize(string);
        this.strings.put(string, value);
        this.values.put(value, string);
    }

    public static Integer toInteger(int val) {
        if (val >= 0 && val < cachedInts.length) {
            return cachedInts[val];
        }
        return new Integer(val);
    }

    public void check(int val) {
        if (val < 0 || val > this.max) {
            throw new IllegalArgumentException(this.description + " " + val + "is out of range");
        }
    }

    public void addAlias(int val, String string) {
        this.check(val);
        Integer value = Mnemonic.toInteger(val);
        string = this.sanitize(string);
        this.strings.put(string, value);
    }

    public void addAll(Mnemonic source) {
        if (this.wordcase != source.wordcase) {
            throw new IllegalArgumentException(source.description + ": wordcases do not match");
        }
        this.strings.putAll(source.strings);
        this.values.putAll(source.values);
    }

    public String getText(int val) {
        this.check(val);
        String str = this.values.get(Mnemonic.toInteger(val));
        if (str != null) {
            return str;
        }
        str = Integer.toString(val);
        if (this.prefix != null) {
            return this.prefix + str;
        }
        return str;
    }

    public int getValue(String str) {
        int val;
        Integer value = this.strings.get(str = this.sanitize(str));
        if (value != null) {
            return value;
        }
        if (this.prefix != null && str.startsWith(this.prefix) && (val = this.parseNumeric(str.substring(this.prefix.length()))) >= 0) {
            return val;
        }
        if (this.numericok) {
            return this.parseNumeric(str);
        }
        return -1;
    }

    private int parseNumeric(String s) {
        try {
            int val = Integer.parseInt(s);
            if (val >= 0 && val <= this.max) {
                return val;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    static {
        for (int i = 0; i < cachedInts.length; ++i) {
            Mnemonic.cachedInts[i] = new Integer(i);
        }
    }
}

