/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.constants;

import dorkbox.network.dns.Mnemonic;
import dorkbox.network.dns.exceptions.InvalidDClassException;

public final class DnsClass {
    public static final int IN = 1;
    public static final int CS = 2;
    public static final int CSNET = 2;
    public static final int CH = 3;
    public static final int CHAOS = 3;
    public static final int HS = 4;
    public static final int HESIOD = 4;
    public static final int NONE = 254;
    public static final int ANY = 255;
    private static Mnemonic classes = new DClassMnemonic();

    private DnsClass() {
    }

    public static void check(int i) {
        if (i < 0 || i > 65535) {
            throw new InvalidDClassException(i);
        }
    }

    public static String string(int i) {
        return classes.getText(i);
    }

    public static int value(String s) {
        return classes.getValue(s);
    }

    static {
        classes.add(1, "IN");
        classes.add(2, "CS");
        classes.addAlias(2, "CSNET");
        classes.add(3, "CH");
        classes.addAlias(3, "CHAOS");
        classes.add(4, "HS");
        classes.addAlias(4, "HESIOD");
        classes.add(254, "NONE");
        classes.add(255, "ANY");
    }

    private static class DClassMnemonic
    extends Mnemonic {
        DClassMnemonic() {
            super("DnsClass", 2);
            this.setPrefix("CLASS");
        }

        @Override
        public void check(int val) {
            DnsClass.check(val);
        }
    }
}

