/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Address;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class A6Record
extends DnsRecord {
    private static final long serialVersionUID = -8815026887337346789L;
    private int prefixBits;
    private InetAddress suffix;
    private Name prefix;

    A6Record() {
    }

    @Override
    DnsRecord getObject() {
        return new A6Record();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.prefixBits = in.readU8();
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        if (this.prefixBits < 128) {
            byte[] bytes = new byte[16];
            in.readByteArray(bytes, 16 - suffixbytes, suffixbytes);
            this.suffix = InetAddress.getByAddress(bytes);
        }
        if (this.prefixBits > 0) {
            this.prefix = new Name(in);
        }
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU8(this.prefixBits);
        if (this.suffix != null) {
            int suffixbits = 128 - this.prefixBits;
            int suffixbytes = (suffixbits + 7) / 8;
            byte[] data = this.suffix.getAddress();
            out.writeByteArray(data, 16 - suffixbytes, suffixbytes);
        }
        if (this.prefix != null) {
            this.prefix.toWire(out, null, canonical);
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.prefixBits);
        if (this.suffix != null) {
            sb.append(" ");
            sb.append(this.suffix.getHostAddress());
        }
        if (this.prefix != null) {
            sb.append(" ");
            sb.append(this.prefix);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.prefixBits = st.getUInt8();
        if (this.prefixBits > 128) {
            throw st.exception("prefix bits must be [0..128]");
        }
        if (this.prefixBits < 128) {
            String s = st.getString();
            try {
                this.suffix = Address.getByAddress(s, 2);
            }
            catch (UnknownHostException e) {
                throw st.exception("invalid IPv6 address: " + s);
            }
        }
        if (this.prefixBits > 0) {
            this.prefix = st.getName(origin);
        }
    }

    public A6Record(Name name, int dclass, long ttl, int prefixBits, InetAddress suffix, Name prefix) {
        super(name, 38, dclass, ttl);
        this.prefixBits = A6Record.checkU8("prefixBits", prefixBits);
        if (suffix != null && Address.familyOf(suffix) != 2) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.suffix = suffix;
        if (prefix != null) {
            this.prefix = A6Record.checkName("prefix", prefix);
        }
    }

    public int getPrefixBits() {
        return this.prefixBits;
    }

    public InetAddress getSuffix() {
        return this.suffix;
    }

    public Name getPrefix() {
        return this.prefix;
    }
}

