/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.util.Base64Fast;
import java.io.IOException;

public class DHCIDRecord
extends DnsRecord {
    private static final long serialVersionUID = -8214820200808997707L;
    private byte[] data;

    DHCIDRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new DHCIDRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.data = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(Base64Fast.encode2(this.data));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.data = st.getBase64();
    }

    public DHCIDRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 49, dclass, ttl);
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }
}

