/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DNSSEC;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.KEYBase;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.security.PublicKey;

public class DNSKEYRecord
extends KEYBase {
    private static final long serialVersionUID = -8679800040426675002L;

    DNSKEYRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new DNSKEYRecord();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.flags = st.getUInt16();
        this.proto = st.getUInt8();
        String algString = st.getString();
        this.alg = DNSSEC.Algorithm.value(algString);
        if (this.alg < 0) {
            throw st.exception("Invalid algorithm: " + algString);
        }
        this.key = st.getBase64();
    }

    public DNSKEYRecord(Name name, int dclass, long ttl, int flags, int proto, int alg, byte[] key) {
        super(name, 48, dclass, ttl, flags, proto, alg, key);
    }

    public DNSKEYRecord(Name name, int dclass, long ttl, int flags, int proto, int alg, PublicKey key) throws DNSSEC.DNSSECException {
        super(name, 48, dclass, ttl, flags, proto, alg, DNSSEC.fromPublicKey(key, alg));
        this.publicKey = key;
    }

    public static class Flags {
        public static final int ZONE_KEY = 256;
        public static final int SEP_KEY = 1;
        public static final int REVOKE = 128;

        private Flags() {
        }
    }

    public static class Protocol {
        public static final int DNSSEC = 3;

        private Protocol() {
        }
    }
}

