/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsClass;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.constants.DnsSection;
import dorkbox.network.dns.exceptions.WireParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.Header;
import dorkbox.network.dns.records.OPTRecord;
import dorkbox.network.dns.records.RRset;
import dorkbox.network.dns.records.SIGRecord;
import dorkbox.network.dns.records.TSIG;
import dorkbox.network.dns.records.TSIGRecord;
import dorkbox.network.dns.records.Update;
import dorkbox.util.OS;
import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DnsMessage
extends AbstractReferenceCounted
implements Cloneable,
ReferenceCounted {
    private static final ResourceLeakDetector<DnsMessage> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DnsMessage.class);
    private final ResourceLeakTracker<DnsMessage> leak;
    public static final int MAXLENGTH = 65535;
    private Header header;
    private Object questions;
    private Object answers;
    private Object authorities;
    private Object additionals;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static DnsRecord[] emptyRecordArray = new DnsRecord[0];
    private static RRset[] emptyRRsetArray = new RRset[0];

    public DnsMessage(int id) {
        this(new Header(id));
    }

    private DnsMessage(Header header) {
        this.leak = leakDetector.track((Object)this);
        this.header = header;
    }

    public DnsMessage() {
        this(new Header());
    }

    public static DnsMessage newQuery(DnsRecord r) {
        DnsMessage m = new DnsMessage();
        m.header.setOpcode(0);
        m.header.setFlag(7);
        m.addRecord(r, 0);
        return m;
    }

    public static DnsMessage newUpdate(Name zone) {
        return new Update(zone);
    }

    public DnsMessage(byte[] b) throws IOException {
        this(new DnsInput(b));
    }

    public DnsMessage(DnsInput in) throws IOException {
        block5: {
            this(new Header(in));
            boolean isUpdate = this.header.getOpcode() == 5;
            boolean truncated = this.header.getFlag(6);
            try {
                for (int i = 0; i < 4; ++i) {
                    int count = this.header.getCount(i);
                    if (count <= 0) continue;
                    ArrayList<DnsRecord> records = DnsMessage.newRecordList(count);
                    this.setSection(i, records);
                    for (int j = 0; j < count; ++j) {
                        SIGRecord sig;
                        int pos = in.readIndex();
                        DnsRecord record = DnsRecord.fromWire(in, i, isUpdate);
                        records.add(record);
                        if (i != 3) continue;
                        if (record.getType() == 250) {
                            this.tsigstart = pos;
                        }
                        if (record.getType() != 24 || (sig = (SIGRecord)record).getTypeCovered() != 0) continue;
                        this.sig0start = pos;
                    }
                }
            }
            catch (WireParseException e) {
                if (truncated) break block5;
                throw e;
            }
        }
        this.size = in.readIndex();
    }

    public DnsMessage(ByteBuf byteBuffer) throws IOException {
        this(new DnsInput(byteBuffer));
    }

    private static <T extends DnsRecord> T castRecord(Object record) {
        return (T)((DnsRecord)record);
    }

    private static ArrayList<DnsRecord> newRecordList(int count) {
        return new ArrayList<DnsRecord>(count);
    }

    private static ArrayList<DnsRecord> newRecordList() {
        return new ArrayList<DnsRecord>(2);
    }

    private Object sectionAt(int section) {
        switch (section) {
            case 0: {
                return this.questions;
            }
            case 1: {
                return this.answers;
            }
            case 2: {
                return this.authorities;
            }
            case 3: {
                return this.additionals;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private void setSection(int section, Object value) {
        switch (section) {
            case 0: {
                this.questions = value;
                return;
            }
            case 1: {
                this.answers = value;
                return;
            }
            case 2: {
                this.authorities = value;
                return;
            }
            case 3: {
                this.additionals = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header h) {
        this.header = h;
    }

    public void addRecord(DnsRecord record, int section) {
        Object records = this.sectionAt(section);
        this.header.incCount(section);
        if (records == null) {
            this.setSection(section, record);
            return;
        }
        if (records instanceof DnsRecord) {
            ArrayList<DnsRecord> recordList = DnsMessage.newRecordList();
            recordList.add((DnsRecord)DnsMessage.castRecord(records));
            recordList.add(record);
            this.setSection(section, recordList);
            return;
        }
        List recordList = (List)records;
        recordList.add(record);
    }

    public boolean removeRecord(DnsRecord record, int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return false;
        }
        if (records instanceof DnsRecord) {
            this.setSection(section, null);
            this.header.decCount(section);
            return true;
        }
        List recordList = (List)records;
        boolean remove = recordList.remove(record);
        if (remove) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        this.setSection(section, null);
        this.header.setCount(section, 0);
    }

    public boolean findRecord(DnsRecord record, int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return false;
        }
        if (records instanceof DnsRecord) {
            return records.equals(record);
        }
        List recordList = (List)records;
        return recordList.contains(record);
    }

    public boolean findRecord(DnsRecord record) {
        for (int i = 1; i <= 3; ++i) {
            if (!this.findRecord(record, i)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public boolean findRRset(Name name, int type, int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return false;
        }
        if (records instanceof DnsRecord) {
            DnsRecord record = (DnsRecord)records;
            return record.getType() == type && name.equals(record.getName());
        }
        List recordList = (List)records;
        for (int i = 0; i < recordList.size(); ++i) {
            DnsRecord record = (DnsRecord)recordList.get(i);
            if (record.getType() != type || !name.equals(record.getName())) continue;
            return true;
        }
        return false;
    }

    public DnsRecord getQuestion() {
        Object records = this.sectionAt(0);
        if (records == null) {
            return null;
        }
        if (records instanceof DnsRecord) {
            return (DnsRecord)records;
        }
        List recordList = (List)records;
        return (DnsRecord)recordList.get(0);
    }

    public TSIGRecord getTSIG() {
        Object records = this.sectionAt(3);
        if (records == null) {
            return null;
        }
        if (records instanceof DnsRecord) {
            DnsRecord record = (DnsRecord)records;
            if (record.type != 250) {
                return null;
            }
            return (TSIGRecord)record;
        }
        List recordList = (List)records;
        DnsRecord record = (DnsRecord)recordList.get(recordList.size() - 1);
        if (record.type != 250) {
            return null;
        }
        return (TSIGRecord)record;
    }

    public RRset[] getSectionRRsets(int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return emptyRRsetArray;
        }
        ArrayList<RRset> sets = new ArrayList<RRset>(this.header.getCount(section));
        HashSet<Name> hash = new HashSet<Name>();
        if (records instanceof DnsRecord) {
            DnsRecord record = (DnsRecord)records;
            return new RRset[]{new RRset(record)};
        }
        List recordList = (List)records;
        for (int i = 0; i < recordList.size(); ++i) {
            DnsRecord record = (DnsRecord)recordList.get(i);
            Name name = record.getName();
            boolean newset = true;
            if (hash.contains(name)) {
                for (int j = sets.size() - 1; j >= 0; --j) {
                    RRset set = (RRset)sets.get(j);
                    if (set.getType() != record.getRRsetType() || set.getDClass() != record.getDClass() || !set.getName().equals(name)) continue;
                    set.addRR(record);
                    newset = false;
                    break;
                }
            }
            if (!newset) continue;
            RRset set = new RRset(record);
            sets.add(set);
            hash.add(name);
        }
        return sets.toArray(new RRset[sets.size()]);
    }

    public DnsRecord[] getSectionArray(int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return emptyRecordArray;
        }
        if (records instanceof DnsRecord) {
            DnsRecord record = (DnsRecord)records;
            return new DnsRecord[]{record};
        }
        List recordList = (List)records;
        return recordList.toArray(new DnsRecord[recordList.size()]);
    }

    public byte[] toWire() {
        DnsOutput out = new DnsOutput();
        this.toWire(out);
        this.size = out.current();
        return out.toByteArray();
    }

    public void toWire(DnsOutput out) {
        this.header.toWire(out);
        Compression c = new Compression();
        for (int i = 0; i < 4; ++i) {
            Object records = this.sectionAt(i);
            if (records == null) continue;
            if (records instanceof DnsRecord) {
                DnsRecord record = (DnsRecord)records;
                record.toWire(out, i, c);
                continue;
            }
            List recordList = (List)records;
            for (int j = 0; j < recordList.size(); ++j) {
                DnsRecord record = (DnsRecord)recordList.get(j);
                record.toWire(out, i, c);
            }
        }
    }

    public byte[] toWire(int maxLength) {
        DnsOutput out = new DnsOutput();
        boolean b = this.toWire(out, maxLength);
        if (!b) {
            System.err.println("ERROR CREATING MESSAGE FROM WIRE!");
        }
        this.size = out.current();
        out.getByteBuf().readerIndex(0);
        return out.toByteArray();
    }

    private boolean toWire(DnsOutput out, int maxLength) {
        if (maxLength < 12) {
            return false;
        }
        Object newheader = null;
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        OPTRecord opt = this.getOPT();
        byte[] optBytes = null;
        if (opt != null) {
            optBytes = opt.toWire(3);
            tempMaxLength -= optBytes.length;
        }
        int startpos = out.current();
        this.header.toWire(out);
        Compression c = new Compression();
        int flags = this.header.getFlagsByte();
        int additionalCount = 0;
        for (int i = 0; i < 4; ++i) {
            Object records = this.sectionAt(i);
            if (records == null) continue;
            int skipped = this.sectionToWire(out, i, c, tempMaxLength);
            if (skipped != 0 && i != 3) {
                flags = Header.setFlag(flags, 6, true);
                out.writeU16At(this.header.getCount(i) - skipped, startpos + 4 + 2 * i);
                for (int j = i + 1; j < 3; ++j) {
                    out.writeU16At(0, startpos + 4 + 2 * j);
                }
                break;
            }
            if (i != 3) continue;
            additionalCount = this.header.getCount(i) - skipped;
        }
        if (optBytes != null) {
            out.writeByteArray(optBytes);
            ++additionalCount;
        }
        if (flags != this.header.getFlagsByte()) {
            out.writeU16At(flags, startpos + 2);
        }
        if (additionalCount != this.header.getCount(3)) {
            out.writeU16At(additionalCount, startpos + 10);
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            tsigrec.toWire(out, 3, c);
            out.writeU16At(additionalCount + 1, startpos + 10);
        }
        return true;
    }

    public OPTRecord getOPT() {
        DnsRecord[] additional = this.getSectionArray(3);
        for (int i = 0; i < additional.length; ++i) {
            if (!(additional[i] instanceof OPTRecord)) continue;
            return (OPTRecord)additional[i];
        }
        return null;
    }

    private int sectionToWire(DnsOutput out, int section, Compression c, int maxLength) {
        Object records = this.sectionAt(section);
        int pos = out.current();
        int rendered = 0;
        int skipped = 0;
        DnsRecord lastRecord = null;
        if (records instanceof DnsRecord) {
            DnsRecord record = (DnsRecord)records;
            if (section == 3 && record.type == 41) {
                return ++skipped;
            }
            record.toWire(out, section, c);
            if (out.current() > maxLength) {
                out.jump(pos);
                return 1 - rendered + skipped;
            }
            return skipped;
        }
        List recordList = (List)records;
        int n = recordList.size();
        for (int i = 0; i < n; ++i) {
            DnsRecord record = (DnsRecord)recordList.get(i);
            if (section == 3 && record.type == 41) {
                ++skipped;
                continue;
            }
            if (lastRecord != null && !DnsMessage.sameSet(record, lastRecord)) {
                pos = out.current();
                rendered = i;
            }
            lastRecord = record;
            record.toWire(out, section, c);
            if (out.current() <= maxLength) continue;
            out.jump(pos);
            return n - rendered + skipped;
        }
        return skipped;
    }

    private static boolean sameSet(DnsRecord r1, DnsRecord r2) {
        return r1.getRRsetType() == r2.getRRsetType() && r1.getDClass() == r2.getDClass() && r1.getName().equals(r2.getName());
    }

    public void setTSIG(TSIG key, int error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public Object clone() {
        DnsMessage m = new DnsMessage();
        for (int i = 0; i < 4; ++i) {
            Object records = this.sectionAt(i);
            if (records == null) continue;
            if (records instanceof DnsRecord) {
                this.setSection(i, records);
                continue;
            }
            List recordList = (List)records;
            this.setSection(i, new ArrayList(recordList));
        }
        m.header = (Header)this.header.clone();
        m.size = this.size;
        return m;
    }

    public String toString() {
        String NL = OS.LINE_SEPARATOR;
        StringBuilder sb = new StringBuilder(NL);
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode())).append(NL);
        } else {
            sb.append(this.header).append(NL);
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append(NL);
        }
        for (int i = 0; i < 4; ++i) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; ").append(DnsSection.longString(i)).append(":").append(NL);
            } else {
                sb.append(";; ").append(DnsSection.updString(i)).append(":").append(NL);
            }
            sb.append(this.sectionToString(i)).append(NL);
        }
        sb.append(";; DnsMessage size: ").append(this.numBytes()).append(" bytes");
        return sb.toString();
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode += opt.getExtendedRcode() << 4;
        }
        return rcode;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int i) {
        if (i > 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        DnsRecord[] records = this.getSectionArray(i);
        for (int j = 0; j < records.length; ++j) {
            DnsRecord rec = records[j];
            if (i == 0) {
                sb.append(";;\t").append(rec.name);
                sb.append(", type = ").append(DnsRecordType.string(rec.type));
                sb.append(", class = ").append(DnsClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append(OS.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public DnsMessage clear() {
        for (int i = 0; i < 4; ++i) {
            this.removeAllRecords(i);
        }
        return this;
    }

    protected void deallocate() {
        this.clear();
        ResourceLeakTracker<DnsMessage> leak = this.leak;
        if (leak != null) {
            boolean closed = leak.close((Object)this);
            assert (closed);
        }
    }

    public DnsMessage touch(Object hint) {
        if (this.leak != null) {
            this.leak.record(hint);
        }
        return this;
    }
}

