/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsClass;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.exceptions.RelativeNameException;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.exceptions.WireParseException;
import dorkbox.network.dns.records.EmptyRecord;
import dorkbox.network.dns.records.RRSIGRecord;
import dorkbox.network.dns.records.TTL;
import dorkbox.network.dns.records.UNKRecord;
import dorkbox.network.dns.utils.Options;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.network.dns.utils.base16;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;

public abstract class DnsRecord
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2694906050116005466L;
    protected Name name;
    protected int type;
    protected int dclass;
    protected long ttl;
    private static final DecimalFormat byteFormat = new DecimalFormat();

    protected DnsRecord() {
    }

    DnsRecord(Name name, int type, int dclass, long ttl) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DnsRecordType.check(type);
        DnsClass.check(dclass);
        TTL.check(ttl);
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
    }

    public static DnsRecord newRecord(Name name, int type, int dclass, long ttl, byte[] data) {
        return DnsRecord.newRecord(name, type, dclass, ttl, data.length, data);
    }

    public static DnsRecord newRecord(Name name, int type, int dclass, long ttl, int length, byte[] data) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DnsRecordType.check(type);
        DnsClass.check(dclass);
        TTL.check(ttl);
        DnsInput in = data != null ? new DnsInput(data) : null;
        try {
            return DnsRecord.newRecord(name, type, dclass, ttl, length, in);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static DnsRecord newRecord(Name name, int type, int dclass, long ttl, int length, DnsInput in) throws IOException {
        DnsRecord rec = DnsRecord.getEmptyRecord(name, type, dclass, ttl, in != null);
        if (in != null) {
            if (in.remaining() < length) {
                throw new WireParseException("truncated record");
            }
            in.setActive(length);
            rec.rrFromWire(in);
            int remaining = in.remaining();
            in.restoreActive();
            if (remaining > 0) {
                throw new WireParseException("invalid record length");
            }
        }
        return rec;
    }

    private static DnsRecord getEmptyRecord(Name name, int type, int dclass, long ttl, boolean hasData) {
        Object proto;
        DnsRecord rec = hasData ? ((proto = DnsRecordType.getProto(type)) != null ? ((DnsRecord)proto).getObject() : new UNKRecord()) : new EmptyRecord();
        rec.name = name;
        rec.type = type;
        rec.dclass = dclass;
        rec.ttl = ttl;
        return rec;
    }

    abstract DnsRecord getObject();

    abstract void rrFromWire(DnsInput var1) throws IOException;

    public static DnsRecord newRecord(Name name, int type, int dclass, long ttl) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DnsRecordType.check(type);
        DnsClass.check(dclass);
        TTL.check(ttl);
        return DnsRecord.getEmptyRecord(name, type, dclass, ttl, false);
    }

    public static DnsRecord newRecord(Name name, int type, int dclass) {
        return DnsRecord.newRecord(name, type, dclass, 0L);
    }

    static DnsRecord fromWire(DnsInput in, int section, boolean isUpdate) throws IOException {
        Name name = new Name(in);
        int type = in.readU16();
        int dclass = in.readU16();
        if (section == 0) {
            return DnsRecord.newRecord(name, type, dclass);
        }
        long ttl = in.readU32();
        int length = in.readU16();
        if (length == 0 && isUpdate && (section == 1 || section == 2)) {
            return DnsRecord.newRecord(name, type, dclass, ttl);
        }
        DnsRecord rec = DnsRecord.newRecord(name, type, dclass, ttl, length, in);
        return rec;
    }

    static DnsRecord fromWire(DnsInput in, int section) throws IOException {
        return DnsRecord.fromWire(in, section, false);
    }

    public static DnsRecord fromWire(byte[] b, int section) throws IOException {
        return DnsRecord.fromWire(new DnsInput(b), section, false);
    }

    public byte[] toWire(int section) {
        DnsOutput out = new DnsOutput();
        this.toWire(out, section, null);
        return out.toByteArray();
    }

    void toWire(DnsOutput out, int section, Compression c) {
        this.name.toWire(out, c);
        out.writeU16(this.type);
        out.writeU16(this.dclass);
        if (section == 0) {
            return;
        }
        out.writeU32(this.ttl);
        int lengthPosition = out.current();
        out.writeU16(0);
        this.rrToWire(out, c, false);
        int rrlength = out.current() - lengthPosition - 2;
        out.writeU16At(rrlength, lengthPosition);
    }

    abstract void rrToWire(DnsOutput var1, Compression var2, boolean var3);

    public byte[] toWireCanonical() {
        return this.toWireCanonical(false);
    }

    private byte[] toWireCanonical(boolean noTTL) {
        DnsOutput out = new DnsOutput();
        this.toWireCanonical(out, noTTL);
        return out.toByteArray();
    }

    private void toWireCanonical(DnsOutput out, boolean noTTL) {
        this.name.toWireCanonical(out);
        out.writeU16(this.type);
        out.writeU16(this.dclass);
        if (noTTL) {
            out.writeU32(0L);
        } else {
            out.writeU32(this.ttl);
        }
        int lengthPosition = out.current();
        out.writeU16(0);
        this.rrToWire(out, null, true);
        int rrlength = out.current() - lengthPosition - 2;
        out.writeU16At(rrlength, lengthPosition);
    }

    public void rdataToString(StringBuilder sb) {
        this.rrToString(sb);
    }

    abstract void rrToString(StringBuilder var1);

    abstract void rdataFromString(Tokenizer var1, Name var2) throws IOException;

    protected static byte[] byteArrayFromString(String s) throws TextParseException {
        byte[] array = s.getBytes();
        boolean escaped = false;
        boolean hasEscapes = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != 92) continue;
            hasEscapes = true;
            break;
        }
        if (!hasEscapes) {
            if (array.length > 255) {
                throw new TextParseException("text string too long");
            }
            return array;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int digits = 0;
        int intval = 0;
        for (int i = 0; i < array.length; ++i) {
            byte b = array[i];
            if (escaped) {
                if (b >= 48 && b <= 57 && digits < 3) {
                    ++digits;
                    intval *= 10;
                    if ((intval += b - 48) > 255) {
                        throw new TextParseException("bad escape");
                    }
                    if (digits < 3) continue;
                    b = (byte)intval;
                } else if (digits > 0 && digits < 3) {
                    throw new TextParseException("bad escape");
                }
                os.write(b);
                escaped = false;
                continue;
            }
            if (array[i] == 92) {
                escaped = true;
                digits = 0;
                intval = 0;
                continue;
            }
            os.write(array[i]);
        }
        if (digits > 0 && digits < 3) {
            throw new TextParseException("bad escape");
        }
        array = os.toByteArray();
        if (array.length > 255) {
            throw new TextParseException("text string too long");
        }
        return os.toByteArray();
    }

    protected static String byteArrayToString(byte[] array, boolean quote) {
        StringBuilder sb = new StringBuilder();
        if (quote) {
            sb.append('\"');
        }
        for (int i = 0; i < array.length; ++i) {
            int b = array[i] & 0xFF;
            if (b < 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
                continue;
            }
            if (b == 34 || b == 92) {
                sb.append('\\');
                sb.append((char)b);
                continue;
            }
            sb.append((char)b);
        }
        if (quote) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected static String unknownToString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\# ");
        sb.append(data.length);
        sb.append(" ");
        sb.append(base16.toString(data));
        return sb.toString();
    }

    public static DnsRecord fromString(Name name, int type, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DnsRecordType.check(type);
        DnsClass.check(dclass);
        TTL.check(ttl);
        Tokenizer.Token t = st.get();
        if (t.type == 3 && t.value.equals("\\#")) {
            int length = st.getUInt16();
            byte[] data = st.getHex();
            if (data == null) {
                data = new byte[]{};
            }
            if (length != data.length) {
                throw st.exception("invalid unknown RR encoding: length mismatch");
            }
            DnsInput in = new DnsInput(data);
            return DnsRecord.newRecord(name, type, dclass, ttl, length, in);
        }
        st.unget();
        DnsRecord rec = DnsRecord.getEmptyRecord(name, type, dclass, ttl, true);
        rec.rdataFromString(st, origin);
        t = st.get();
        if (t.type != 1 && t.type != 0) {
            throw st.exception("unexpected tokens at end of record");
        }
        return rec;
    }

    public static DnsRecord fromString(Name name, int type, int dclass, long ttl, String s, Name origin) throws IOException {
        return DnsRecord.fromString(name, type, dclass, ttl, new Tokenizer(s), origin);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public boolean sameRRset(DnsRecord rec) {
        return this.getRRsetType() == rec.getRRsetType() && this.dclass == rec.dclass && this.name.equals(rec.name);
    }

    public int getRRsetType() {
        if (this.type == 46) {
            RRSIGRecord sig = (RRSIGRecord)this;
            return sig.getTypeCovered();
        }
        return this.type;
    }

    public int hashCode() {
        byte[] array = this.toWireCanonical(true);
        int code = 0;
        for (int i = 0; i < array.length; ++i) {
            code += (code << 3) + (array[i] & 0xFF);
        }
        return code;
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof DnsRecord)) {
            return false;
        }
        DnsRecord r = (DnsRecord)arg;
        if (this.type != r.type || this.dclass != r.dclass || !this.name.equals(r.name)) {
            return false;
        }
        byte[] array1 = this.rdataToWireCanonical();
        byte[] array2 = r.rdataToWireCanonical();
        return Arrays.equals(array1, array2);
    }

    public byte[] rdataToWireCanonical() {
        DnsOutput out = new DnsOutput();
        this.rrToWire(out, null, true);
        return out.toByteArray();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        if (sb.length() < 8) {
            sb.append("\t");
        }
        if (sb.length() < 16) {
            sb.append("\t");
        }
        sb.append("\t");
        if (Options.check("BINDTTL")) {
            sb.append(TTL.format(this.ttl));
        } else {
            sb.append(this.ttl);
        }
        sb.append("\t");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DnsClass.string(this.dclass));
            sb.append("\t");
        }
        sb.append(DnsRecordType.string(this.type));
        sb.append("\t");
        int length = sb.length();
        this.rrToString(sb);
        if (length == sb.length()) {
            sb.deleteCharAt(length - 1);
        }
    }

    public DnsRecord withName(Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DnsRecord rec = this.cloneRecord();
        rec.name = name;
        return rec;
    }

    DnsRecord cloneRecord() {
        try {
            return (DnsRecord)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    DnsRecord withDClass(int dclass, long ttl) {
        DnsRecord rec = this.cloneRecord();
        rec.dclass = dclass;
        rec.ttl = ttl;
        return rec;
    }

    public int compareTo(Object o) {
        DnsRecord arg = (DnsRecord)o;
        if (this == arg) {
            return 0;
        }
        int n = this.name.compareTo(arg.name);
        if (n != 0) {
            return n;
        }
        n = this.dclass - arg.dclass;
        if (n != 0) {
            return n;
        }
        n = this.type - arg.type;
        if (n != 0) {
            return n;
        }
        byte[] rdata1 = this.rdataToWireCanonical();
        byte[] rdata2 = arg.rdataToWireCanonical();
        for (int i = 0; i < rdata1.length && i < rdata2.length; ++i) {
            n = (rdata1[i] & 0xFF) - (rdata2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return rdata1.length - rdata2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static int checkU8(String field, int val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 8 bit value");
        }
        return val;
    }

    static int checkU16(String field, int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 16 bit value");
        }
        return val;
    }

    static long checkU32(String field, long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 32 bit value");
        }
        return val;
    }

    static Name checkName(String field, Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        return name;
    }

    static byte[] checkByteArrayLength(String field, byte[] array, int maxLength) {
        if (array.length > 65535) {
            throw new IllegalArgumentException("\"" + field + "\" array must have no more than " + maxLength + " elements");
        }
        byte[] out = new byte[array.length];
        System.arraycopy(array, 0, out, 0, array.length);
        return out;
    }

    static {
        byteFormat.setMinimumIntegerDigits(3);
    }
}

