/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Mnemonic;
import dorkbox.network.dns.exceptions.WireParseException;
import dorkbox.network.dns.records.ClientSubnetOption;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.GenericEDNSOption;
import dorkbox.network.dns.records.NSIDOption;
import java.io.IOException;
import java.util.Arrays;

public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int code) {
        this.code = DnsRecord.checkU16("code", code);
    }

    public int getCode() {
        return this.code;
    }

    public static EDNSOption fromWire(byte[] b) throws IOException {
        return EDNSOption.fromWire(new DnsInput(b));
    }

    static EDNSOption fromWire(DnsInput in) throws IOException {
        EDNSOption option;
        int code = in.readU16();
        int length = in.readU16();
        if (in.remaining() < length) {
            throw new WireParseException("truncated option");
        }
        in.setActive(length);
        switch (code) {
            case 3: {
                option = new NSIDOption();
                break;
            }
            case 8: {
                option = new ClientSubnetOption();
                break;
            }
            default: {
                option = new GenericEDNSOption(code);
            }
        }
        option.optionFromWire(in);
        in.restoreActive();
        return option;
    }

    abstract void optionFromWire(DnsInput var1) throws IOException;

    public byte[] toWire() throws IOException {
        DnsOutput out = new DnsOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    void toWire(DnsOutput out) {
        out.writeU16(this.code);
        int lengthPosition = out.current();
        out.writeU16(0);
        this.optionToWire(out);
        int length = out.current() - lengthPosition - 2;
        out.writeU16At(length, lengthPosition);
    }

    abstract void optionToWire(DnsOutput var1);

    public int hashCode() {
        byte[] array = this.getData();
        int hashval = 0;
        for (int i = 0; i < array.length; ++i) {
            hashval += (hashval << 3) + (array[i] & 0xFF);
        }
        return hashval;
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof EDNSOption)) {
            return false;
        }
        EDNSOption opt = (EDNSOption)arg;
        if (this.code != opt.code) {
            return false;
        }
        return Arrays.equals(this.getData(), opt.getData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(Code.string(this.code));
        sb.append(": ");
        sb.append(this.optionToString());
        sb.append("}");
        return sb.toString();
    }

    abstract String optionToString();

    byte[] getData() {
        DnsOutput out = new DnsOutput();
        this.optionToWire(out);
        return out.toByteArray();
    }

    public static class Code {
        public static final int NSID = 3;
        public static final int CLIENT_SUBNET = 8;
        private static Mnemonic codes = new Mnemonic("EDNS Option Codes", 2);

        private Code() {
        }

        public static String string(int code) {
            return codes.getText(code);
        }

        public static int value(String s) {
            return codes.getValue(s);
        }

        static {
            codes.setMaximum(65535);
            codes.setPrefix("CODE");
            codes.setNumericAllowed(true);
            codes.add(3, "NSID");
            codes.add(8, "CLIENT_SUBNET");
        }
    }
}

