/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class ISDNRecord
extends DnsRecord {
    private static final long serialVersionUID = -8730801385178968798L;
    private byte[] address;
    private byte[] subAddress;

    ISDNRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new ISDNRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.address = in.readCountedString();
        if (in.remaining() > 0) {
            this.subAddress = in.readCountedString();
        }
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.address);
        if (this.subAddress != null) {
            out.writeCountedString(this.subAddress);
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(ISDNRecord.byteArrayToString(this.address, true));
        if (this.subAddress != null) {
            sb.append(" ");
            sb.append(ISDNRecord.byteArrayToString(this.subAddress, true));
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.address = ISDNRecord.byteArrayFromString(st.getString());
            Tokenizer.Token t = st.get();
            if (t.isString()) {
                this.subAddress = ISDNRecord.byteArrayFromString(t.value);
            } else {
                st.unget();
            }
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public ISDNRecord(Name name, int dclass, long ttl, String address, String subAddress) {
        super(name, 20, dclass, ttl);
        try {
            this.address = ISDNRecord.byteArrayFromString(address);
            if (subAddress != null) {
                this.subAddress = ISDNRecord.byteArrayFromString(subAddress);
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String getAddress() {
        return ISDNRecord.byteArrayToString(this.address, false);
    }

    public String getSubAddress() {
        if (this.subAddress == null) {
            return null;
        }
        return ISDNRecord.byteArrayToString(this.subAddress, false);
    }
}

