/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.network.dns.utils.base16;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class NSAPRecord
extends DnsRecord {
    private static final long serialVersionUID = -1037209403185658593L;
    private byte[] address;

    NSAPRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new NSAPRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.address = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append("0x").append(base16.toString(this.address));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String addr = st.getString();
        this.address = NSAPRecord.checkAndConvertAddress(addr);
        if (this.address == null) {
            throw st.exception("invalid NSAP address " + addr);
        }
    }

    public NSAPRecord(Name name, int dclass, long ttl, String address) {
        super(name, 22, dclass, ttl);
        this.address = NSAPRecord.checkAndConvertAddress(address);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid NSAP address " + address);
        }
    }

    private static byte[] checkAndConvertAddress(String address) {
        if (!address.substring(0, 2).equalsIgnoreCase("0x")) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        boolean partial = false;
        int current = 0;
        for (int i = 2; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (c == '.') continue;
            int value = Character.digit(c, 16);
            if (value == -1) {
                return null;
            }
            if (partial) {
                bytes.write(current += value);
                partial = false;
                continue;
            }
            current = value << 4;
            partial = true;
        }
        if (partial) {
            return null;
        }
        return bytes.toByteArray();
    }

    public String getAddress() {
        return NSAPRecord.byteArrayToString(this.address, false);
    }
}

