/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.NSEC3Record;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.network.dns.utils.base16;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class NSEC3PARAMRecord
extends DnsRecord {
    private static final long serialVersionUID = -8689038598776316533L;
    private int hashAlg;
    private int flags;
    private int iterations;
    private byte[] salt;

    NSEC3PARAMRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new NSEC3PARAMRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.hashAlg = in.readU8();
        this.flags = in.readU8();
        this.iterations = in.readU16();
        int salt_length = in.readU8();
        this.salt = (byte[])(salt_length > 0 ? in.readByteArray(salt_length) : null);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU8(this.hashAlg);
        out.writeU8(this.flags);
        out.writeU16(this.iterations);
        if (this.salt != null) {
            out.writeU8(this.salt.length);
            out.writeByteArray(this.salt);
        } else {
            out.writeU8(0);
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.hashAlg);
        sb.append(' ');
        sb.append(this.flags);
        sb.append(' ');
        sb.append(this.iterations);
        sb.append(' ');
        if (this.salt == null) {
            sb.append('-');
        } else {
            sb.append(base16.toString(this.salt));
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.hashAlg = st.getUInt8();
        this.flags = st.getUInt8();
        this.iterations = st.getUInt16();
        String s = st.getString();
        if (s.equals("-")) {
            this.salt = null;
        } else {
            st.unget();
            this.salt = st.getHexString();
            if (this.salt.length > 255) {
                throw st.exception("salt value too long");
            }
        }
    }

    public NSEC3PARAMRecord(Name name, int dclass, long ttl, int hashAlg, int flags, int iterations, byte[] salt) {
        super(name, 51, dclass, ttl);
        this.hashAlg = NSEC3PARAMRecord.checkU8("hashAlg", hashAlg);
        this.flags = NSEC3PARAMRecord.checkU8("flags", flags);
        this.iterations = NSEC3PARAMRecord.checkU16("iterations", iterations);
        if (salt != null) {
            if (salt.length > 255) {
                throw new IllegalArgumentException("Invalid salt length");
            }
            if (salt.length > 0) {
                this.salt = new byte[salt.length];
                System.arraycopy(salt, 0, this.salt, 0, salt.length);
            }
        }
    }

    public int getHashAlgorithm() {
        return this.hashAlg;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getIterations() {
        return this.iterations;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] hashName(Name name) throws NoSuchAlgorithmException {
        return NSEC3Record.hashName(name, this.hashAlg, this.iterations, this.salt);
    }
}

