/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.constants.DnsRecordType;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;
import java.util.BitSet;

public class NXTRecord
extends DnsRecord {
    private static final long serialVersionUID = -8851454400765507520L;
    private Name next;
    private BitSet bitmap;

    NXTRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new NXTRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.next = new Name(in);
        this.bitmap = new BitSet();
        int bitmapLength = in.remaining();
        for (int i = 0; i < bitmapLength; ++i) {
            int t = in.readU8();
            for (int j = 0; j < 8; ++j) {
                if ((t & 1 << 7 - j) == 0) continue;
                this.bitmap.set(i * 8 + j);
            }
        }
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, canonical);
        int length = this.bitmap.length();
        int t = 0;
        for (int i = 0; i < length; ++i) {
            t |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 != 7 && i != length - 1) continue;
            out.writeU8(t);
            t = 0;
        }
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.next);
        int length = this.bitmap.length();
        for (int i = 0; i < length; i = (int)((short)(i + 1))) {
            if (!this.bitmap.get(i)) continue;
            sb.append(" ");
            sb.append(DnsRecordType.string(i));
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.next = st.getName(origin);
        this.bitmap = new BitSet();
        while ((t = st.get()).isString()) {
            int typecode = DnsRecordType.value(t.value, true);
            if (typecode <= 0 || typecode > 128) {
                throw st.exception("Invalid type: " + t.value);
            }
            this.bitmap.set(typecode);
        }
        st.unget();
    }

    public NXTRecord(Name name, int dclass, long ttl, Name next, BitSet bitmap) {
        super(name, 30, dclass, ttl);
        this.next = NXTRecord.checkName("next", next);
        this.bitmap = bitmap;
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }
}

