/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Options;
import dorkbox.network.dns.utils.Tokenizer;
import dorkbox.util.Base64Fast;
import dorkbox.util.OS;
import java.io.IOException;

public class OPENPGPKEYRecord
extends DnsRecord {
    private static final long serialVersionUID = -1277262990243423062L;
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new OPENPGPKEYRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.cert = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }

    @Override
    void rrToString(StringBuilder sb) {
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(").append(OS.LINE_SEPARATOR);
                sb.append(Base64Fast.formatString(Base64Fast.encode2(this.cert), 64, "\t", true));
            } else {
                sb.append("\t");
                sb.append(Base64Fast.encode2(this.cert));
            }
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    public byte[] getCert() {
        return this.cert;
    }
}

