/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class PXRecord
extends DnsRecord {
    private static final long serialVersionUID = 1811540008806660667L;
    private int preference;
    private Name map822;
    private Name mapX400;

    PXRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new PXRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.preference = in.readU16();
        this.map822 = new Name(in);
        this.mapX400 = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.preference);
        this.map822.toWire(out, null, canonical);
        this.mapX400.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.preference);
        sb.append(" ");
        sb.append(this.map822);
        sb.append(" ");
        sb.append(this.mapX400);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.preference = st.getUInt16();
        this.map822 = st.getName(origin);
        this.mapX400 = st.getName(origin);
    }

    public PXRecord(Name name, int dclass, long ttl, int preference, Name map822, Name mapX400) {
        super(name, 26, dclass, ttl);
        this.preference = PXRecord.checkU16("preference", preference);
        this.map822 = PXRecord.checkName("map822", map822);
        this.mapX400 = PXRecord.checkName("mapX400", mapX400);
    }

    public int getPreference() {
        return this.preference;
    }

    public Name getMap822() {
        return this.map822;
    }

    public Name getMapX400() {
        return this.mapX400;
    }
}

