/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class RPRecord
extends DnsRecord {
    private static final long serialVersionUID = 8124584364211337460L;
    private Name mailbox;
    private Name textDomain;

    RPRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new RPRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.mailbox = new Name(in);
        this.textDomain = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.mailbox.toWire(out, null, canonical);
        this.textDomain.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.mailbox);
        sb.append(" ");
        sb.append(this.textDomain);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.mailbox = st.getName(origin);
        this.textDomain = st.getName(origin);
    }

    public RPRecord(Name name, int dclass, long ttl, Name mailbox, Name textDomain) {
        super(name, 17, dclass, ttl);
        this.mailbox = RPRecord.checkName("mailbox", mailbox);
        this.textDomain = RPRecord.checkName("textDomain", textDomain);
    }

    public Name getMailbox() {
        return this.mailbox;
    }

    public Name getTextDomain() {
        return this.textDomain;
    }
}

