/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.records.DNSSEC;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.KEYRecord;
import dorkbox.network.dns.records.SIGRecord;
import dorkbox.network.dns.utils.Options;
import java.security.PrivateKey;
import java.util.Date;

public class SIG0 {
    private static final short VALIDITY = 300;

    private SIG0() {
    }

    public static void signMessage(DnsMessage dnsMessage, KEYRecord key, PrivateKey privkey, SIGRecord previous) throws DNSSEC.DNSSECException {
        int validity = Options.intValue("sig0validity");
        if (validity < 0) {
            validity = 300;
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        SIGRecord sig = DNSSEC.signMessage(dnsMessage, previous, key, privkey, timeSigned, timeExpires);
        dnsMessage.addRecord(sig, 3);
    }

    public static void verifyMessage(DnsMessage dnsMessage, byte[] b, KEYRecord key, SIGRecord previous) throws DNSSEC.DNSSECException {
        SIGRecord sig = null;
        DnsRecord[] additional = dnsMessage.getSectionArray(3);
        for (int i = 0; i < additional.length; ++i) {
            if (additional[i].getType() != 24 || ((SIGRecord)additional[i]).getTypeCovered() != 0) continue;
            sig = (SIGRecord)additional[i];
            break;
        }
        DNSSEC.verifyMessage(dnsMessage, b, sig, previous, key);
    }
}

